@props(['user', 'reviewsStats'])
<div class="py-12 border-b border-solid border-gray-1200">
    <h6>{{ __('Reviews') }}</h6>
    <div class="flex gap-6 items-center mt-5 sm:gap-8">
        <div class="sm:max-w-[238px] max-w-[159px] w-full">
            <h4 class="font-semibold text-[56px] leading-16 text-black-1200">
                {{ number_format($reviewsStats['average_rating'] ?? 4.91, 2) }}
            </h4>
            <div class="flex gap-1.5 items-center my-3">
                <x-frontend.review.partials.review-average-star-yellow :rating="$reviewsStats['average_rating'] ?? 4.91" color="black" />
            </div>
            <p class="sm:text-base text-sm font-medium leading-6 tracking-[-0.176px] text-mid-gray">
                {{ __('Based on :count reviews', ['count' => $reviewsStats['total_reviews'] ?? 320]) }}
            </p>
        </div>
        <div class="flex-1 w-full">
            @php
                $ratings = [];
                $total = 0;
                if (isset($reviewsStats['rating_distribution'])) {
                    foreach ($reviewsStats['rating_distribution'] as $rating => $data) {
                        $ratings[$rating] = $data['count'];
                        $total += $data['count'];
                    }
                } else {
                    $ratings = [
                        5 => 0,
                        4 => 0,
                        3 => 0,
                        2 => 0,
                        1 => 0
                    ];
                }
            @endphp
            @for ($i = 5; $i >= 1; $i--)
                <div class="flex gap-2 items-center mb-1.5">
                    <span class="text-sm font-medium leading-5 tracking-[-0.096px] flex items-center justify-center w-5 h-5">{{ $i }}</span>
                    <div class="flex-1 w-full h-1.5 rounded-full bg-gray-1200">
                        <div class="h-1.5 rounded-full bg-black-1300" style="width: {{ $total > 0 ? round((($ratings[$i] ?? 0) / $total) * 100) : 0 }}%"></div>
                    </div>
                </div>
            @endfor
        </div>
    </div>
    <div class="grid grid-cols-2 gap-6 mt-12 mb-6 lg:grid-cols-5 sm:grid-cols-3 2xl:gap-6 lg:gap-0 sm:gap-4">
        @php
            $ratingTypes = [
                'service_quality' => [
                    'icon' => 'icon-favourite-circle',
                    'label' => __('Service Quality')
                ],
                'response_time' => [
                    'icon' => 'icon-clock-icon2',
                    'label' => __('Response Time')
                ],
                'professionalism' => [
                    'icon' => 'icon-suit',
                    'label' => __('Professionalism')
                ],
                'value_for_money' => [
                    'icon' => 'icon-money',
                    'label' => __('Value for Money')
                ],
                'communication' => [
                    'icon' => 'icon-message-multiple',
                    'label' => __('Communication')
                ]
            ];
        @endphp

        @foreach($ratingTypes as $type => $config)
            <div class="px-4 xl:px-4 md:px-2.5">
                <span class="flex items-center">
                    <x-dynamic-component :component="$config['icon']" />
                </span>
                <p class="text-mid-gray xl:text-sm text-xs mt-6 font-medium leading-6 tracking-[-0.096px]">
                    {{ $config['label'] }}
                </p>
                <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">
                    {{ number_format($reviewsStats['rating_types'][$type]['average'] ?? 0, 1) }} 
                </h4>
            </div>
        @endforeach
    </div>
    <button type="button"
        class="readmore-btn !text-mid-gray cursor-pointer"
        onclick="document.getElementById('profile-reviews-styled-tab').click()">{{ __('Read all') }} {{ $reviewsStats['total_reviews'] ?? 320 }} {{ __('reviews') }}</button>
</div>
