@props(['user'])
@php
    $services_areas = $user->profile?->service_areas ?? [];
@endphp

@if ($services_areas)
    <div class="p-4 bg-white sm:rounded-xl shadow-4xl xl:p-6">
        <h4 class="text-xl  font-bold leading-[130%] text-primary-blue">{{ __(':name Service Area', ['name' => $user->profile?->company_name]) }}</h4>
        <ul class="flex items-center flex-wrap sm:gap-2 gap-[7px] mt-4">
            @foreach ($services_areas as $service_area)
                <li>
                    <a href="#" class="text-gray-1500 font-medium xl:text-[15px] sm:text-xs text-[13px] xl:leading-[18px] leading-4 rounded-[100px] bg-gray-1400 hover:bg-primary-blue hover:text-white transition-all duration-500 ease-in-out inline-flex items-center justify-center xl:h-[30px] sm:h-[26px] h-7 xl:px-[10.6px] sm:px-2 px-[11px]">{{ $service_area }}</a>
                </li>
            @endforeach
        </ul>
    </div>
@endif
