@props(['user', 'text' => 'Social Profiles','mainClass' => ''])
@php
    $socialMedia = $user->profile->social_media_links ?? [];
    $website = $user->profile->website ?? null;
@endphp
<div class="{{ $mainClass ? $mainClass : 'pt-12' }}">
    <h6>{{ $text }}</h6>
    <ul class="flex gap-3 items-center mt-5">
        @if (!empty($socialMedia['facebook']))
            <li>
                <a href="{{ $socialMedia['facebook'] }}"
                    target="_blank"
                    class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                    <x-icon-facebook />
                </a>
            </li>
        @endif

        @if (!empty($socialMedia['twitter']))
            <li>
                <a href="{{ $socialMedia['twitter'] }}"
                    target="_blank"
                    class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                    <x-icon-twitter-x />
                </a>
            </li>
        @endif

        @if (!empty($socialMedia['linkedin']))
            <li>
                <a href="{{ $socialMedia['linkedin'] }}"
                    target="_blank"
                    class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                    <x-icon-linkedin />
                </a>
            </li>
        @endif

        @if (!empty($socialMedia['instagram']))
            <li>
                <a href="{{ $socialMedia['instagram'] }}"
                    target="_blank"
                    class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                    <x-icon-instagram />
                </a>
            </li>
        @endif
        @if (!empty($socialMedia['youtube']))
            <li>
                <a href="{{ $socialMedia['youtube'] }}"
                    target="_blank"
                    class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                    <x-icon-youtube-v2/>
                </a>
            </li>
        @endif
        @if (!empty($socialMedia['pinterest']))
            <li>
                <a href="{{ $socialMedia['pinterest'] }}"
                    target="_blank"
                    class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                    <x-icon-pinterest />
                </a>
            </li>
        @endif
        @if (!empty($socialMedia['tiktok']))
            <li>
                <a href="{{ $socialMedia['tiktok'] }}"
                    target="_blank"
                    class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                    <x-icon-tiktok />
                </a>
            </li>
        @endif
        @if ($website)
            <li>
                <a href="{{ $website }}"
                    target="_blank"
                    class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                    <x-icon-link />
                </a>
            </li>
        @endif
    </ul>
</div>

