<div class="flex justify-between items-center px-6 pt-6 pb-3 border-b border-solid xl:hidden border-gray-1200">
    <h6 class="flex gap-3 items-center">
        <x-icon-list-bars />
        {{ __('Filter') }}
        <span class="flex justify-center items-center w-6 h-6 text-xs font-medium text-white rounded-full bg-primary-blue">4</span>
    </h6>
    <div class="flex gap-3 items-center">
        <a href="javascript:void(0)"
            x-on:click="$wire.resetFilters(); openFilter = false;"
            class="flex text-primary-blue gap-2 items-center justify-center font-medium text-sm tracking-[-0.096px]">
            {{ __('Clear all') }}
        </a>
        <a href="javascript:void(0)"
            x-on:click="openFilter = false"
            class="flex justify-center items-center w-6 h-6 filter-close">
            <x-icon-close-icon />
        </a>
    </div>
</div>

<div class="xl:h-auto h-[calc(100vh_-_65px)] lg:overflow-y-auto xl:p-0 p-6">
    <div class="p-6 mb-8 bg-white rounded-2xl border border-solid border-gray-1200 shadow-10xl">
        <div class="hidden justify-between items-center mb-6 xl:flex">
            <h4 class="text-xl font-medium leading-7 text-black-1200">{{ __('Filter by') }}</h4>
            <a href="javascript:void(0)"
                x-on:click="$wire.resetFilters(); openFilter = false;"
                class="font-medium text-sm leading-5 tracking-[-0.096px] gap-2.5 text-primary-blue flex items-center">
                <x-icon-close-icon />
                {{ __('Clear all') }}
            </a>
        </div>
        <form>
            <div class="mb-6">
                <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Search') }}
                </h4>
                <div class="relative mt-1">
                    <input type="text"
                        wire:model.live.debounce.500ms="search"
                        class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full pl-10"
                        placeholder="Search..." />
                    <a href="javascript:void(0)" class="flex absolute left-3.5 top-1/2 justify-center items-center -translate-y-1/2">
                        <x-icon-search-icon />
                    </a>
                </div>
            </div>
            <div class="pt-6 pb-4 border-b border-solid border-gray-1600" x-data="{ openCategory: true }">
                <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openCategory = !openCategory">
                    <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Category') }}</h4>
                    <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openCategory }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>
                <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                    x-show="openCategory"
                    x-transition:enter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition duration-300 ease-in-out"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                    <div x-data="{ showAllCategories: false }">
                        <ul>
                            @foreach ($categoriesList->take(3) as $categoryItem)
                                <li wire:key="category-{{ $categoryItem->slug }}">
                                    <div class="flex items-center mb-2">
                                        <input id="{{ $categoryItem->slug }}"
                                            type="checkbox"
                                            wire:model.live="category"
                                            value="{{ $categoryItem->slug }}"
                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="{{ $categoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                            {{ $categoryItem->category_name }}
                                        </label>
                                    </div>
                                </li>
                            @endforeach
                        </ul>

                        @if ($categoriesList->count() > 3)
                            <div x-show="showAllCategories"
                                x-transition:enter="transition duration-300 ease-in-out"
                                x-transition:enter-start="opacity-0 transform -translate-y-2"
                                x-transition:enter-end="opacity-100 transform translate-y-0"
                                x-transition:leave="transition duration-300 ease-in-out"
                                x-transition:leave-start="opacity-100 transform translate-y-0"
                                x-transition:leave-end="opacity-0 transform -translate-y-2">
                                <ul>
                                    @foreach ($categoriesList->skip(3) as $categoryItem)
                                        <li wire:key="category-{{ $categoryItem->slug }}">
                                            <div class="flex items-center mb-2">
                                                <input id="{{ $categoryItem->slug }}"
                                                    type="checkbox"
                                                    wire:model.live="category"
                                                    value="{{ $categoryItem->slug }}"
                                                    class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="{{ $categoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                    {{ $categoryItem->category_name }}
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>

                            <a @click="showAllCategories = !showAllCategories" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                <span x-text="showAllCategories ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($categoriesList) }}'"></span>
                                <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllCategories }">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                        @endif
                    </div>
                </div>
            </div>
            @if ($subcategoriesList->count() > 0)
                <div class="py-6 border-b border-solid border-gray-1600" x-data="{ openSubcategory: true }">
                    <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openSubcategory = !openSubcategory">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Subcategory') }}</h4>
                        <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openSubcategory }">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                        x-show="openSubcategory"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition duration-300 ease-in-out"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-2">
                        <div x-data="{ showAllSubcategories: false }">
                            <ul>
                                @foreach ($subcategoriesList->take(3) as $subcategoryItem)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="{{ $subcategoryItem->slug }}"
                                                type="checkbox"
                                                value="{{ $subcategoryItem->slug }}"
                                                wire:model.live="subcategory"
                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="{{ $subcategoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                {{ $subcategoryItem->category_name }}
                                            </label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>

                            @if ($subcategoriesList->count() > 3)
                                <div x-show="showAllSubcategories"
                                    x-transition:enter="transition duration-300 ease-in-out"
                                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                                    x-transition:enter-end="opacity-100 transform translate-y-0"
                                    x-transition:leave="transition duration-300 ease-in-out"
                                    x-transition:leave-start="opacity-100 transform translate-y-0"
                                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                                    <ul>
                                        @foreach ($subcategoriesList->skip(3) as $subcategoryItem)
                                            <li wire:key="subcategory-{{ $subcategoryItem->slug }}">
                                                <div class="flex items-center mb-2">
                                                    <input id="{{ $subcategoryItem->slug }}"
                                                        type="checkbox"
                                                        wire:model.live="subcategory"
                                                        value="{{ $subcategoryItem->slug }}"
                                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="{{ $subcategoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $subcategoryItem->category_name }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>

                                <a @click="showAllSubcategories = !showAllSubcategories" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                    <span x-text="showAllSubcategories ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($subcategoriesList) }}'"></span>
                                    <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllSubcategories }">
                                        <x-icon-down-arrow-outline />
                                    </span>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
            @if ($specificCategoriesList->count() > 0)
                <div class="py-6" x-data="{ openSpecificServices: true }">
                    <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openSpecificServices = !openSpecificServices">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Specific Services') }}</h4>
                        <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openSpecificServices }">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                        x-show="openSpecificServices"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition duration-300 ease-in-out"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-2">
                        <div x-data="{ showAllSpecificServices: false }">
                            <ul>
                                @foreach ($specificCategoriesList->take(3) as $specificCategoryItem)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="{{ $specificCategoryItem->slug }}"
                                                type="checkbox"
                                                value="{{ $specificCategoryItem->slug }}"
                                                wire:model.live="specificCategory"
                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="{{ $specificCategoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                {{ $specificCategoryItem->category_name }}
                                            </label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                            @if ($specificCategoriesList->count() > 3)
                                <div x-show="showAllSpecificServices"
                                    x-transition:enter="transition duration-300 ease-in-out"
                                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                                    x-transition:enter-end="opacity-100 transform translate-y-0"
                                    x-transition:leave="transition duration-300 ease-in-out"
                                    x-transition:leave-start="opacity-100 transform translate-y-0"
                                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                                    <ul>
                                        @foreach ($specificCategoriesList->skip(3) as $specificCategoryItem)
                                            <li wire:key="specific-category-{{ $specificCategoryItem->slug }}">
                                                <div class="flex items-center mb-2">
                                                    <input id="{{ $specificCategoryItem->slug }}"
                                                        type="checkbox"
                                                        value="{{ $specificCategoryItem->slug }}"
                                                        wire:model.live="specificCategory"
                                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="{{ $specificCategoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $specificCategoryItem->category_name }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>

                                <a @click="showAllSpecificServices = !showAllSpecificServices" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                    <span x-text="showAllSpecificServices ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($specificCategoriesList) }}'"></span>
                                    <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllSpecificServices }">
                                        <x-icon-down-arrow-outline />
                                    </span>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
            
           

            <div class="pt-6 pb-4 border-b border-solid border-gray-1600" x-data="{ openRating: true }">
                <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openRating = !openRating">
                    <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Rating') }}</h4>
                    <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openRating }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>
                <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                    x-show="openRating"
                    x-transition:enter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition duration-300 ease-in-out"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                    <ul>
                        @foreach ($this->getRatingData() as $index => $rating)
                            <li>
                                <div class="flex items-center {{ $loop->last ? '' : 'mb-2' }}">
                                    <input id="rating-checkbox-{{ $rating['value'] }}"
                                        type="checkbox"
                                        value="{{ $rating['value'] }}"
                                        wire:model.live="rating"
                                        class="w-4 h-4 bg-transparent rounded-sm text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="rating-checkbox-{{ $rating['value'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-[#2D2E2E] flex items-center justify-between flex-1 w-full">{{ $rating['label'] }} <span class="text-xs leading-4 text-mid-gray hidden">{{ $rating['count'] }}</span></label>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <div class="pt-6" x-data="{ openFeatures: true }">
                <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openFeatures = !openFeatures">
                    <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Profile Features') }}
                    </h4>
                    <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openFeatures }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>

                <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                    x-show="openFeatures"
                    x-transition:enter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition duration-200 ease-in-out"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                    <ul>
                        @foreach ($profileFeatures as $feature)
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="feature-{{ $feature['id'] }}"
                                        type="checkbox"
                                        value="{{ $feature['id'] }}"
                                        wire:model.live="features"
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="feature-{{ $feature['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                        {{ $feature['name'] }}
                                        <span class="text-xs leading-4 text-mid-gray hidden">
                                            
                                            @if ($feature['id'] === 'emergency')
                                                {{ $profileEmergencyCount }}
                                            @elseif ($feature['id'] === 'reviews')
                                                {{ $profileReviewsCount }}
                                            @elseif ($feature['id'] === 'open_now')
                                                {{ $profileOpenNowCount }}
                                            @endif
                                        </span>
                                    </label>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </form>
    </div>
    @if ($areas->isNotEmpty())
        <div class="p-6 mb-8 bg-white rounded-2xl border border-solid border-gray-1200 shadow-10xl">
            <h4 class="mb-3 text-xl font-medium leading-7 text-black-1200">Service area</h4>
            <ul class="flex flex-wrap gap-2">
                @foreach ($areas as $area)
                    <li><a href="#" class="tags !border-0 !h-7 !px-3.5">{{ $area->name }}</a></li>
                @endforeach
            </ul>
            <a href="#" class="flex items-center mt-5 text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 text-primary-blue">
                {{ __('Show all :count', ['count' => $areas->count()]) }}
                <x-icon-down-arrow2 />
            </a>
        </div>
    @endif
    <div class="p-6 rounded-2xl border border-solid bg-gray-1400 border-gray-1200">
        <h4 class="mb-5">
            <a href="#" class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px] flex items-center  gap-9">Water
                Well Drilling Estimates
                <x-icon-right-long-arrow-v2 />
            </a>
        </h4>
        <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.096px]">Lorem Ipsum is
            simply
            dummy text of the printing and typesetting</p>
    </div>
</div>
