<div class="flex justify-between items-center px-6 pt-6 pb-3 border-b border-solid lg:pb-0 lg:border-0 border-gray-1200">
    <h6 class="hidden lg:block">
        {{ __('Filter by') }}
    </h6>
    <h6 class="flex gap-3 items-center lg:hidden">
        <x-icon-list-bars />
        {{ __('Filter') }}
        <span class="flex justify-center items-center w-6 h-6 text-xs font-medium text-white rounded-full bg-primary-blue">4</span>
    </h6>
    <div class="flex gap-3 items-center">
        <a x-on:click="$wire.resetFilters(); openFilter = false;" class="flex text-primary-blue gap-2 items-center justify-center font-medium text-sm tracking-[-0.096px] cursor-pointer">
            <x-icon-close-icon class="hidden lg:block" /> {{ __('Clear all') }}
        </a>
        <a class="flex justify-center items-center w-6 h-6 cursor-pointer lg:hidden" @click="openFilter = false">
            <x-icon-close-icon />
        </a>
    </div>
</div>
<div class="filter-sidebar lg:px-px lg:h-auto lg:overflow-y-auto h-[calc(100vh_-_154px)] overflow-y-scroll">
    <div class="px-6 py-8 lg:py-6">
        <form class="relative" wire:submit.prevent="applySearch">
            <div>
                <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Search') }}</h4>
                <div class="relative mt-1">
                    <input type="text"
                        wire:model.live.debounce.500ms="search"
                        class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full pl-10"
                        placeholder="Search..." />
                    <a class="flex absolute left-3.5 top-1/2 justify-center items-center -translate-y-1/2">
                        <x-icon-search-icon />
                    </a>
                </div>
            </div>
            <div class="pt-6 pb-4 border-b border-solid border-gray-1600" x-data="{ openLocation: true }">
                <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openLocation = !openLocation">
                    <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Location') }}</h4>
                    <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openLocation }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>
                <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                    x-show="openLocation"
                    x-transition:enter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition duration-300 ease-in-out"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                    <ul>
                        <li>
                            <div class="flex items-center mb-2">
                                <input id="country-all"
                                    type="radio"
                                    value=""
                                    wire:model.live="country"
                                    class="w-[18px] h-[18px] bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0" />
                                <label for="country-all" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                    {{ __('Any') }}
                                    <span class="text-xs leading-4 text-mid-gray">
                                        ({{ $members->total() }})
                                    </span>
                                </label>
                            </div>
                        </li>

                        @foreach ($countryList as $countryItem)
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="country-{{ $countryItem->slug }}"
                                        type="radio"
                                        value="{{ $countryItem->slug }}"
                                        wire:model.live="country"
                                        class="w-[18px] h-[18px] bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0" />
                                    <label for="country-{{ $countryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                        {{ $countryItem->country_name }}
                                        <span class="text-xs leading-4 text-mid-gray">
                                            ({{ $countryItem->members()->count() }})
                                        </span>
                                    </label>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                    @if ($country)
                        @if ($stateList)
                            <div class="mb-4">
                                <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('State') }}</h4>
                                <div class="relative mt-1">
                                    <select wire:model.live="state" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                        <option value="">{{ __('Select State') }}</option>
                                        @foreach ($stateList as $stateItem)
                                            <option value="{{ $stateItem->slug }}">{{ $stateItem->state_name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                        <x-icon-down-arrow-outline />
                                    </span>
                                </div>
                            </div>
                        @endif
                        @if ($state)
                            <div>
                                <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('City or Zip') }}</h4>
                                <div x-data="{ lat: null, lng: null }" class="relative mt-1">
                                    <input id="city-input-{{ $this->getId() }}"
                                        type="text"
                                        wire:model="city"
                                        class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3"
                                        placeholder="{{ __('Type city or zip') }}" />
                                    {{-- Clear icon that only appears when there's a value --}}
                                    @if ($city)
                                        <button type="button"
                                            x-on:click="$wire.set('city', null); $wire.set('lat', null); $wire.set('lng', null);"
                                            class="absolute right-4 top-1/2 text-gray-500 -translate-y-1/2 hover:text-gray-700 focus:outline-none"
                                            title="{{ __('Clear') }}">
                                            <x-icon-clear-field class="w-5 h-5" />
                                        </button>
                                    @endif

                                    <input type="hidden"
                                        id="lat-{{ $this->getId() }}"
                                        wire:model="lat"
                                        x-model="lat">

                                    <input type="hidden"
                                        id="lng-{{ $this->getId() }}"
                                        wire:model="lng"
                                        x-model="lng">
                                </div>

                                {{-- Radius Selection --}}
                                <div class="mt-4">
                                    <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px] mb-3">{{ __('Radius') }}</h4>
                                    <ul>
                                        @foreach ($radiusList as $radiusItem)
                                            <li>
                                                <div class="flex items-center {{ $loop->last ? '' : 'mb-2' }}">
                                                    <input id="radius-{{ $radiusItem['id'] }}"
                                                        wire:model.live="radius"
                                                        type="radio"
                                                        value="{{ $radiusItem['id'] }}"
                                                        class="w-[18px] h-[18px] bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0" />
                                                    <label for="radius-{{ $radiusItem['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                        {{ $radiusItem['name'] }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                    @if ($radius == 'custom')
                                        <div class="mt-3">
                                            <input type="text"
                                                wire:model.blur="customRadius"
                                                class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3"
                                                placeholder="{{ __('Enter custom radius') }}" />
                                            @error('customRadius')
                                                <span class="block mt-1 text-sm text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif
                    @endif
                </div>
            </div>

            <div class="pt-6 pb-4 border-b border-solid border-gray-1600" x-data="{ openCategory: true }">
                <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openCategory = !openCategory">
                    <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Category') }}</h4>
                    <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openCategory }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>
                <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                    x-show="openCategory"
                    x-transitienter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition duration-300 ease-in-out"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                    <div x-data="{ showAllCategories: false }">
                        <ul>
                            @foreach ($categoriesList->take(3) as $categoryItem)
                                <li wire:key="category-{{ $categoryItem->slug }}">
                                    <div class="flex items-center mb-2">
                                        <input id="{{ $categoryItem->slug }}"
                                            type="checkbox"
                                            wire:model.live="category"
                                            value="{{ $categoryItem->slug }}"
                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="{{ $categoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                            {{ $categoryItem->category_name }}
                                        </label>
                                    </div>
                                </li>
                            @endforeach
                        </ul>

                        @if ($categoriesList->count() > 3)
                            <div x-show="showAllCategories"
                                x-transition:enter="transition duration-300 ease-in-out"
                                x-transition:enter-start="opacity-0 transform -translate-y-2"
                                x-transition:enter-end="opacity-100 transform translate-y-0"
                                x-transition:leave="transition duration-300 ease-in-out"
                                x-transition:leave-start="opacity-100 transform translate-y-0"
                                x-transition:leave-end="opacity-0 transform -translate-y-2">
                                <ul>
                                    @foreach ($categoriesList->skip(3) as $categoryItem)
                                        <li wire:key="category-{{ $categoryItem->slug }}">
                                            <div class="flex items-center mb-2">
                                                <input id="{{ $categoryItem->slug }}"
                                                    type="checkbox"
                                                    wire:model.live="category"
                                                    value="{{ $categoryItem->slug }}"
                                                    class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="{{ $categoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                    {{ $categoryItem->category_name }}
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>

                            <a @click="showAllCategories = !showAllCategories" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                <span x-text="showAllCategories ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($categoriesList) }}'"></span>
                                <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllCategories }">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                        @endif
                    </div>
                </div>
            </div>
            @if ($subcategoriesList->count() > 0)
                <div class="pt-6 pb-4 border-b border-solid border-gray-1600" x-data="{ openSubcategory: true }">
                    <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openSubcategory = !openSubcategory">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Subcategory') }}</h4>
                        <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openSubcategory }">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                        x-show="openSubcategory"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition duration-300 ease-in-out"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-2">
                        <div x-data="{ showAllSubcategories: false }">
                            <ul>
                                @foreach ($subcategoriesList->take(3) as $subcategoryItem)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="{{ $subcategoryItem->slug }}"
                                                type="checkbox"
                                                value="{{ $subcategoryItem->slug }}"
                                                wire:model.live="subcategory"
                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="{{ $subcategoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                {{ $subcategoryItem->category_name }}
                                            </label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>

                            @if ($subcategoriesList->count() > 3)
                                <div x-show="showAllSubcategories"
                                    x-transition:enter="transition duration-300 ease-in-out"
                                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                                    x-transition:enter-end="opacity-100 transform translate-y-0">
                                    <ul>
                                        @foreach ($subcategoriesList->skip(3) as $subcategoryItem)
                                            <li wire:key="subcategory-{{ $subcategoryItem->slug }}">
                                                <div class="flex items-center mb-2">
                                                    <input id="{{ $subcategoryItem->slug }}"
                                                        type="checkbox"
                                                        wire:model.live="subcategory"
                                                        value="{{ $subcategoryItem->slug }}"
                                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="{{ $subcategoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $subcategoryItem->category_name }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>

                                <a @click="showAllSubcategories = !showAllSubcategories" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                    <span x-text="showAllSubcategories ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($subcategoriesList) }}'"></span>
                                    <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllSubcategories }">
                                        <x-icon-down-arrow-outline />
                                    </span>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
            @if ($specificCategoriesList->count() > 0)
                <div class="pt-6 pb-4 border-b border-solid border-gray-1600" x-data="{ openSpecificServices: true }">
                    <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openSpecificServices = !openSpecificServices">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Specific Services') }}</h4>
                        <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openSpecificServices }">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                        x-show="openSpecificServices"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition duration-300 ease-in-out"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-2">
                        <div x-data="{ showAllSpecificServices: false }">
                            <ul>
                                @foreach ($specificCategoriesList->take(3) as $specificCategoryItem)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="{{ $specificCategoryItem->slug }}"
                                                type="checkbox"
                                                value="{{ $specificCategoryItem->slug }}"
                                                wire:model.live="specificCategory"
                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="{{ $specificCategoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                {{ $specificCategoryItem->category_name }}
                                            </label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                            @if ($specificCategoriesList->count() > 3)
                                <div x-show="showAllSpecificServices"
                                    x-transition:enter="transition duration-300 ease-in-out"
                                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                                    x-transition:enter-end="opacity-100 transform translate-y-0"
                                    x-transition:leave="transition duration-300 ease-in-out"
                                    x-transition:leave-start="opacity-100 transform translate-y-0"
                                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                                    <ul>
                                        @foreach ($specificCategoriesList->skip(3) as $specificCategoryItem)
                                            <li wire:key="specific-category-{{ $specificCategoryItem->slug }}">
                                                <div class="flex items-center mb-2">
                                                    <input id="{{ $specificCategoryItem->slug }}"
                                                        type="checkbox"
                                                        value="{{ $specificCategoryItem->slug }}"
                                                        wire:model.live="specificCategory"
                                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="{{ $specificCategoryItem->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $specificCategoryItem->category_name }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>

                                <a @click="showAllSpecificServices = !showAllSpecificServices" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                    <span x-text="showAllSpecificServices ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($specificCategoriesList) }}'"></span>
                                    <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllSpecificServices }">
                                        <x-icon-down-arrow-outline />
                                    </span>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endif

            <div class="pt-6 pb-4 border-b border-solid border-gray-1600" x-data="{ openRating: true }">
                <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openRating = !openRating">
                    <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Rating') }}</h4>
                    <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openRating }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>
                <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                    x-show="openRating"
                    x-transition:enter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition duration-300 ease-in-out"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                    <ul>
                        @foreach ($this->getRatingData() as $index => $rating)
                            <li>
                                <div class="flex items-center {{ $loop->last ? '' : 'mb-2' }}">
                                    <input id="rating-checkbox-{{ $rating['value'] }}"
                                        type="checkbox"
                                        value="{{ $rating['value'] }}"
                                        wire:model.live="rating"
                                        class="w-4 h-4 bg-transparent rounded-sm text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="rating-checkbox-{{ $rating['value'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-[#2D2E2E] flex items-center justify-between flex-1 w-full">{{ $rating['label'] }} <span class="text-xs leading-4 text-mid-gray hidden">{{ $rating['count'] }}</span></label>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <div class="pt-6" x-data="{ openFeatures: true }">
                <a class="flex justify-between items-center cursor-pointer collapse-btn" @click="openFeatures = !openFeatures">
                    <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px] cursor-pointer">{{ __('Profile Features') }}
                    </h4>
                    <span class="flex justify-center items-center w-5 h-5 transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': openFeatures }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>

                <div class="overflow-hidden mt-3 transition-all duration-300 ease-in-out"
                    x-show="openFeatures"
                    x-transition:enter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition duration-200 ease-in-out"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-2">
                    <ul>
                        @foreach ($profileFeatures as $feature)
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="feature-{{ $feature['id'] }}"
                                        type="checkbox"
                                        value="{{ $feature['id'] }}"
                                        wire:model.live="features"
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="feature-{{ $feature['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                        {{ $feature['name'] }}
                                        <span class="text-xs leading-4 text-mid-gray hidden">
                                            @if ($feature['id'] === 'emergency')
                                                {{ \App\Models\User\User::whereHas('profile', function ($q) {
                                                    $q->whereExists(function ($query) {
                                                        $query->from('user_profiles_meta')->whereColumn('user_profiles_meta.user_profile_id', 'user_profiles.id')->where('user_profiles_meta.key', 'emergency_service_enabled')->where('user_profiles_meta.value', '1');
                                                    });
                                                })->count() }}
                                            @else
                                                {{ \App\Models\User\User::whereHas('reviews')->count() }}
                                            @endif
                                        </span>
                                    </label>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="block absolute bottom-0 left-0 p-6 w-full bg-white border-t border-solid lg:hidden border-gray-1200">
    <a class="cursor-pointer primary-btn" @click="openFilter = false">{{ __('Show :count Results', ['count' => $members->total()]) }}</a>
</div>
<!-- The Google Maps initialization code has been moved to esp_theme.js -->
