@props(['package', 'isYearly' => true])
@php
    use Illuminate\Support\Str;
    $features = $package->features;
@endphp
<div class="bg-white border border-solid border-gray-1200/[0.5] rounded-2xl 2xl:p-6 xl:p-5 md:p-6 px-4 pt-4 pb-8 {{ $package->is_best_value == 1 ? 'relative best-value shadow-15xl' : ($package->is_most_popular == 1 ? 'relative active-pro shadow-15xl' : 'shadow-28xl') }}">
    @if ($package->is_best_value == 1)
        <span class="absolute left-1/2 -translate-x-1/2 top-[-18px] flex items-center justify-center text-white font-bold text-sm leading-normal h-7 w-[96px] rounded-lg pb-px bg-blue-2200">
            {{ __('Best Value') }}
        </span>
    @elseif ($package->is_most_popular == 1)
        <span class="absolute left-1/2 -translate-x-1/2 top-[-18px] flex items-center justify-center text-white font-bold text-sm leading-normal h-7 w-[96px] rounded-lg pb-px bg-yellow-1800">
            {{ __('Most Popular') }}
        </span>
    @endif
    <h4 class="text-2xl font-medium leading-8 text-black-1200">{{ $package->package_title }}</h4>
    <p class="text-mid-gray text-base mt-1 font-normal leading-6 tracking-[-0.32px]">
        {{ $package->package_description }}
    </p>

    @if ($isYearly && $package->price_yearly > 0)
        <h5 class="text-black-1200  mt-5 mb-6  text-[32px] font-semibold leading-10 tracking-[-0.64px]">
            {{ esp_currency_formated($package->price_yearly) }}
            <span class="text-base font-normal">{{ __('Per year') }}</span>
        </h5>
    @elseif ($package->price_monthly > 0)
        <h5 class="text-black-1200  mt-5 mb-6  text-[32px] font-semibold leading-10 tracking-[-0.64px]">
            {{ esp_currency_formated($package->price_monthly) }}
            <span class="text-base font-normal">{{ __('Per month') }}</span>
        </h5>
    @elseif (!$isYearly && $package->price_monthly == 0 && $package->price_yearly > 0)
        <h5 class="text-black-1200  mt-5 mb-6  text-[32px] font-semibold leading-10 tracking-[-0.64px]">
            {{ esp_currency_formated($package->price_yearly) }}
            <span class="text-base font-normal">{{ __('Per year') }}</span>
        </h5>
    @endif
    @if ($package->is_most_popular == 1)
        <a href="#" class="text-black-1200 text-base font-bold leading-5 tracking-[-0.32px] w-full h-[52px] rounded-full  flex items-center justify-center btn-gradient shadow-24xl">
            {{ __('Get started') }}
        </a>
    @else
        <a href="#" class="text-white text-base font-medium leading-5 tracking-[-0.32px] w-full h-[52px] rounded-full secondary-btn-gradient flex items-center justify-center  shadow-16xl">
            {{ __('Get started') }}
        </a>
    @endif
    @if ($features)
        <div class="mt-8 min-h-[214px]">
            <h5 class="text-black-1200 mb-3 text-base font-medium leading-6 tracking-[-0.32px]">
                {{ __('What’s include') }}
            </h5>
            <ul>
                @foreach ($features as $key => $feature)
                    <li class="mb-4 flex items-center gap-2 text-mid-gray text-base font-normal tracking-[-0.32px]">
                        <span class="w-[18px] h-[18px] flex items-center justify-center">
                            <x-icon-check-icon />
                        </span>
                        <p class="flex-1 w-full"> {{ $feature['feature_name'] }} </p>
                    </li>
                @endforeach
            </ul>
        </div>
    @endif
</div>
