@props(['project'])
@php
    $projectImage = $project->getFirstMediaUrl('featured_image', 'thumb');
    $projectDescription = html_entity_decode(strip_tags($project->description), ENT_QUOTES | ENT_HTML5, 'UTF-8');
@endphp
<div>
    <a href="{{ route('project.show', $project->slug) }}" class="group hover:shadow-10xl mt-5 transition-all duration-500 ease-in-out bg-white border border-solid border-gray-1200 rounded-2xl p-6 shadow-7xl flex items-center gap-4 sm:flex-row flex-col">
        <div class="flex items-center flex-col sm:w-[162px] w-full sm:h-[112px] h-[166px] border border-solid border-gray-1200 rounded-xl">
            @if ($projectImage)
                <img src="{{ $projectImage }}"
                    alt="{{ $project->title }}"
                    class="rounded-xl w-full h-full object-cover object-center" />
            @endif
        </div>
        <div class="flex-1 w-full">
            <div class="flex items-center justify-between mb-1.5">
                <span class="tags !border-0">
                    {{ ucfirst($project->types->first()->type_name) }}
                </span>
                <span class="flex items-center justify-center opacity-0 group-hover:opacity-100 transition-all duration-500 ease-in-out">
                    <x-icon-right-top-arrow />
                </span>
            </div>

            <h4 class="font-medium text-base leading-6 tracking-[-0.176px]  text-black-1200">
                {{ str()->limit($project->title, 70) }}
            </h4>
            @if (!empty($project->description))
                <p class="text-sm font-normal leading-5 tracking-[-0.096px] mt-1.5 text-mid-gray line-clamp-2">
                    {!! tiptap_converter()->asText(str()->limit($projectDescription, 200)) !!}
                </p>
            @endif
        </div>
    </a>
</div>
