@props(['project', 'target' => '_self'])
@php
    $projectImage = $project->getFirstMediaUrl('featured_image', 'thumb');
    $projectDescription = html_entity_decode(strip_tags($project->description), ENT_QUOTES | ENT_HTML5, 'UTF-8');
@endphp
<div>
    <a href="{{ route('project.show', $project->slug) }}"
        target="{{ $target }}">
        <div class="flex flex-col p-6 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out group hover:shadow-10xl border-gray-1200 shadow-7xl">
            @if ($projectImage)
                <div class="flex flex-col items-center">
                    <img src="{{ $projectImage }}" alt="{{ $project->title }}" class="rounded-xl w-full h-[166px] object-cover object-center" />
                </div>
            @endif
            <div class="pt-4">
                <div class="flex justify-between items-center mb-1.5">
                    @if ($project->types->isNotEmpty())
                        <div class="w-full">
                            <span class="tags !border-0 cursor-pointer">
                                {{ ucfirst($project->types->first()?->type_name) }}
                            </span>
                        </div>
                    @endif
                    <span class="flex justify-center items-center">
                        <x-icon-right-top-arrow />
                    </span>
                </div>

                <h4 class="cursor-pointer font-medium text-base leading-6 tracking-[-0.176px]  text-black-1200">{{ str()->limit($project->title, 35) }}</h4>

                @if (!empty($project->description))
                    <p class="text-sm font-normal leading-5 tracking-[-0.096px] mt-1.5 text-mid-gray line-clamp-2">
                        {!! tiptap_converter()->asText(str()->limit($projectDescription, 100)) !!}
                    </p>
                @endif
            </div>
        </div>
    </a>
</div>
