<div class="border-b border-solid border-gray-1200 py-12">
    <div class="flex items-center justify-between">
        <h6>{{ __('Related Projects') }}</h6>
        <a href="" class="hidden text-mid-gray hover:text-black-1200 w-[81px] font-medium text-sm leading-5 tracking-[-0.096px] flex items-center justify-center bg-gray-1400 hover:bg-white border border-solid border-gray-1400 hover:border-gray-1200 transition-all duration-500 ease-in-out rounded-full h-10">
            {{ __('View All') }}
        </a>
    </div>
    @if ($relatedProjects->count() > 0)
        <div>
            @foreach ($relatedProjects as $project)
                <x-frontend.project.project-card-list :project="$project" />
            @endforeach
        </div>
    @else
        <div class="mt-12">
            <x-common.no-records-found>
                <x-slot:icon>
                    <x-icon-search-icon />
                </x-slot:icon>
                <x-slot:title>
                    {{ __('No related projects found') }}
                </x-slot:title>
                <x-slot:description>
                    {{ __('No related projects found') }}
                </x-slot:description>
            </x-common.no-records-found>
        </div>
    @endif
</div>
