@props(['reviewsStats' => []])

@php
    $average_rating = $reviewsStats['average_rating'] ?? null;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
@endphp
@if (!empty($average_rating))
    <span class="text-primary-blue sm:text-[32px] text-2xl leading-[130%] flex items-center justify-center mx-auto rounded-[32px] rounded-tl-none bg-yellow-1300 sm:w-[75px] w-[63px] sm:h-11 h-[38px]">
        {{ $average_rating }}
    </span>
@endif
@if ($rating_count)
    <p class="text-primary-blue font-normal sm:text-[15px] text-[13px] leading-[150%] sm:my-3 my-2">
        {{ __('Based on') }} {{ $rating_count }} {{ __('reviews') }}
    </p>
@endif
