@props(['rating', 'class' => '', 'size' => 'w-4 h-4', 'gap' => 'gap-1', 'wrapper' => 'flex items-center', 'color' => 'yellow'])

@php
    // Extract rating from the rating object or use as float
    $rating = is_object($rating) ? (float) ($rating->review_rating ?? 0) : (float) $rating;
    $rating = max(0, min(5, $rating)); // Clamp between 0 and 5

    // Calculate full stars and partial star
    $fullStars = floor($rating);
    $decimal = $rating - $fullStars;

    // Show partial star if there's any decimal value
$hasPartialStar = $decimal > 0;
$partialPercentage = $decimal * 100; // Convert to percentage for CSS

// Calculate empty stars
$emptyStars = 5 - $fullStars - ($hasPartialStar ? 1 : 0);

// Define colors based on the color prop
$fillColor = $color === 'black' ? '#000000' : '#FFBB00';
$emptyColor = $color === 'black' ? '#E5E7EB' : '#D1D5DB';

// Generate unique ID for gradient
$gradientId = 'star-gradient-' . $color . '-' . uniqid();
@endphp

<div class="{{ $wrapper }} {{ $gap }} {{ $class }}">
    {{-- Full Stars --}}
    @for ($i = 0; $i < $fullStars; $i++)
        <svg viewBox="0 0 18 18" class="{{ $size }} flex-shrink-0">
            <path d="M9 0L12.0593 5.52274L18 6.87539L13.95 11.6413L14.5623 18L9 15.4227L3.43769 18L4.05 11.6413L0 6.87539L5.94073 5.52274L9 0Z" fill="{{ $fillColor }}" />
        </svg>
    @endfor

    {{-- Partial Star (if needed) --}}
    @if ($hasPartialStar)
        <svg viewBox="0 0 18 18" class="{{ $size }} flex-shrink-0">
            <defs>
                <linearGradient id="{{ $gradientId }}"
                    x1="0%"
                    y1="0%"
                    x2="100%"
                    y2="0%">
                    <stop offset="{{ $partialPercentage }}%" style="stop-color:{{ $fillColor }};stop-opacity:1" />
                    <stop offset="{{ $partialPercentage }}%" style="stop-color:{{ $emptyColor }};stop-opacity:1" />
                </linearGradient>
            </defs>
            <path d="M9 0L12.0593 5.52274L18 6.87539L13.95 11.6413L14.5623 18L9 15.4227L3.43769 18L4.05 11.6413L0 6.87539L5.94073 5.52274L9 0Z" fill="url(#{{ $gradientId }})" />
        </svg>
    @endif

    {{-- Empty Stars --}}
    @for ($i = 0; $i < $emptyStars; $i++)
        <svg viewBox="0 0 18 18" class="{{ $size }} flex-shrink-0">
            <path d="M9 0L12.0593 5.52274L18 6.87539L13.95 11.6413L14.5623 18L9 15.4227L3.43769 18L4.05 11.6413L0 6.87539L5.94073 5.52274L9 0Z" fill="{{ $emptyColor }}" />
        </svg>
    @endfor
</div>
