@props(['reviewsStats'])
<div class="text-center sm:mb-0 mb-5 sm:border-r border-solid border-primary-blue/[0.3]">
    <x-frontend.review.partials.member-average-rating-v1 :reviewsStats="$reviewsStats" />

    <x-frontend.review.partials.review-average-star :rating="$reviewsStats" />
</div>
<div class="2xl:max-w-[270px] lg:max-w-[200px] max-w-full lg:pl-0 pl-4 w-full ml-auto">
    @for ($i = 5; $i >= 1; $i--)
        <div class="flex items-center 2xl:gap-4 sm:gap-1.5 gap-0 mb-1">
            <ul class="flex items-center sm:gap-1.5 gap-[2px] max-w-[84px] w-full">
                @for ($j = 0; $j < $i; $j++)
                    <li><x-icon-star class="w-3" /></li>
                @endfor
            </ul>
            <div class="w-full bg-primary-blue/[0.1] sm:mx-0 mx-1.5 rounded-full h-2.5 flex-1">
                <x-frontend.review.partials.star-progress-bar-v1 :progress="$reviewsStats['rating_distribution'][$i]['percentage']" />
            </div>
            <x-frontend.review.partials.star-rating-count-v1 :count="$reviewsStats['rating_distribution'][$i]['count']" />
        </div>

    @endfor
</div>
