@props(['review'])
<div class="py-12 border-b border-solid border-gray-1200">
    <div class="flex items-center gap-3">
        <div class="w-12 flex items-center">
            <x-frontend.member.profile.partials.profile-avatar :user="$review->user" class="rounded-full w-12 h-12 object-cover object-center" />
        </div>
        <div class="flex-1 w-full">
            <h4 class="text-black-1200 font-semibold text-base flex items-center gap-1">
                {{ $review->user->name }}
                {{-- @if ($review->user->is_verified) --}}
                <x-icon-verify-icon class="h-[18px]" />
                {{-- @endif --}}
            </h4>
            @if ($review?->user?->address())
                <p class="text-mid-gray font-medium mt-2 text-sm tracking-[-0.096px] flex items-start gap-2 leading-normal">
                    <x-icon-location-outline-v2 class="mt-[3px]" />
                    {{ $review->user->address('short') }}
                </p>
            @endif
        </div>
        @if ($review->getMedia('review_attachments')->count() > 0)
            <ul class="flex items-center gap-2 sm:mt-0 mt-3 review-gallery" id="review-gallery-{{ $review->id }}">
                @foreach ($review->getMedia('review_attachments') as $media)
                    @if ($loop->index < 3)
                        @if ($loop->index == 2)
                            <li class="relative block">
                                <div class="relative">
                                    <a href="{{ $media->getUrl() }}" data-sub-html="<h4>{{ $review->title }}</h4><p>By {{ $review->user->name }}</p>" class="flex items-center rounded-xl review-gallery-item">
                                        <img src="{{ $media->getUrl('thumb') }}" alt="{{ $review->title }}" class="sm:w-12 w-[42px] sm:h-12 h-[42px] object-fill rounded-xl" />
                                    
                                    @if ($loop->index == 2 && $review->getMedia('review_attachments')->count() > 3)
                                        <div class="absolute bottom-0 left-0 right-0 top-0 flex items-center justify-center bg-black-100 bg-opacity-750 rounded-xl">
                                            <span class="text-white text-xs font-semibold">+{{ $review->getMedia('review_attachments')->count() - 3 }}</span>
                                        </div>
                                    @endif
                                </a>
                                </div>
                            </li>
                        @else
                            <li class="block">
                                <a href="{{ $media->getUrl() }}" data-sub-html="<h4>{{ $review->title }}</h4><p>By {{ $review->user->name }}</p>" class="flex items-center rounded-xl review-gallery-item">
                                    <img src="{{ $media->getUrl('thumb') }}" alt="{{ $review->title }}" class="sm:w-12 w-[42px] sm:h-12 h-[42px] object-fill rounded-xl" />
                                </a>
                            </li>
                        @endif
                    @else
                        <li class="hidden">
                            <a href="{{ $media->getUrl() }}" data-sub-html="<h4>{{ $review->title }}</h4><p>By {{ $review->user->name }}</p>" class="flex items-center rounded-xl review-gallery-item">
                                <img src="{{ $media->getUrl('thumb') }}" alt="{{ $review->title }}" class="sm:w-12 w-[42px] sm:h-12 h-[42px] object-fill rounded-xl" />
                            </a>
                        </li>
                    @endif
                @endforeach
            </ul>
        @endif
    </div>
    <div class="flex items-center gap-2 mt-3.5">
        <x-frontend.review.partials.review-average-star-yellow :rating="$review" color="black" size="h-2.5" />
        <span class="bg-mid-gray w-1.5 h-1.5 rounded-full flex items-center"></span>
        @if ($review->getReviewCreatedTimeFormatAttribute())
            <p class="text-black-1200 text-xs font-semibold">{{ $review->getReviewCreatedTimeFormatAttribute() }}</p>
        @endif
    </div>
    <div class="mt-4">
        <h4 class="text-black-1200 font-semibold text-base leading-6">
            {{ $review->title }}
        </h4>
        @if ($review->review_content)
            <div x-data="{ expanded: false }">
                <p x-ref="content" :style="expanded ? 'max-height: ' + $refs.content.scrollHeight + 'px' : 'max-height: 4.5rem'" class="text-mid-gray font-normal text-base my-2 leading-6 overflow-hidden transition-all duration-500 ease-in-out">
                    {{ $review->review_content }}
                </p>
                @if (strlen($review->review_content) > 200)
                    <button @click="expanded = !expanded" class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] inline-flex items-center gap-1 underline transition-all duration-300 hover:opacity-80">
                        <span x-text="expanded ? 'Show less' : 'Show more'" class="transition-all duration-300"></span>
                        <svg width="11" height="7" viewBox="0 0 11 7" fill="none" xmlns="http://www.w3.org/2000/svg" :class="expanded ? 'rotate-180' : ''" class="transform transition-transform duration-500 ease-in-out">
                            <path d="M5.49999 4.54697L9.21249 0.834473L10.273 1.89497L5.49999 6.66797L0.72699 1.89497L1.78749 0.834473L5.49999 4.54697Z" fill="#525866" />
                        </svg>
                    </button>
                @endif
            </div>
        @endif
        <ul class="flex items-center gap-3 mt-5">
            <li>
                <a href="#" class="inline-flex items-center text-mid-gray text-sm font-medium tracking-[-0.096px] gap-1.5 bg-gray-1400 rounded-[100px] h-8 px-[11px]">
                    <x-icon-like-icon class="w-4 h-4" /> {{ __('Helpful') }} (20)</a>
            </li>
            <li>
                <a href="#" class="inline-flex items-center text-mid-gray text-sm font-medium tracking-[-0.096px] gap-1.5 bg-gray-1400 rounded-[100px] h-8 px-[11px]">
                    <x-icon-flag /> {{ __('Report') }}</a>
            </li>
        </ul>
    </div>
</div>
