@props(['user', 'reviewsStats'])
@php
    use Illuminate\Support\Str;
    $mapUrl = $user->mapUrl;
    $address = $user->address();
    $mapIframeUrl = $user->mapIframeUrl();
@endphp
<div class="bg-white rounded-2xl shadow-33xl border border-solid border-gray-1200 xl:p-6 p-4">
    <div class="relative">
        <a href="{{ route('member.show', ['slug' => $user->slug]) }}">
            <div class="relative border border-solid border-gray-1200 rounded-2xl w-[72px] p-1.5 h-[72px] flex items-center justify-center">
                @if ($user->getMedia('logo')->count() > 0)
                    <img src="{{ $user->getFirstMediaUrl('logo', 'small') }}"
                        alt="{{ $user->name }}"
                        class="rounded-xl" />
                @else
                    <img src="{{ $user->getFirstMediaUrl('avatar', 'small') }}"
                        alt="{{ $user->name }}"
                        class="rounded-xl" />
                @endif
                <span class="flex items-center justify-center absolute -right-3.5 -top-3.5">
                    <x-icon-verify-icon />
                </span>
            </div>
        </a>
    </div>

    <div class="mt-3">
        <a href="{{ route('member.show', ['slug' => $user->slug]) }}">
            <h4 class="text-black-1200 font-medium text-xl mb-3 leading-7">
                {{ $user->memberName() }}
            </h4>
        </a>
        @if ($user->parentCategories(limit: 1))
            <a href="#" class="tags">
                {{ Str::title($user->parentCategories(limit: 1)->first()->category_name) }}
            </a>
        @endif
        <div class="mt-3">
            @if ($reviewsStats['average_rating'] && $reviewsStats['total_reviews'])
                <ul class="flex items-center gap-[5px]">
                    @if (!empty($reviewsStats['average_rating']))
                        <x-frontend.review.partials.review-average-star-yellow :rating="$reviewsStats['average_rating'] ?? 4.91" />
                    @endif
                    @if (!empty($reviewsStats['total_reviews']))
                        <li class="ml-1.5">
                            <a class="flex items-center font-medium xl:text-sm text-xs tracking-[-0.096px] text-mid-gray underline underline-offset-2">
                                {{ $reviewsStats['total_reviews'] }}
                                {{ __('reviews') }}
                            </a>
                        </li>
                    @endif
                </ul>
            @endif
            @if ($user->address() || !empty($user->profile->year_established))
                <ul class="mt-3">
                    @if ($user->address())
                        <li class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm md:tracking-[-0.096px] tracking-[-0.084px] flex items-center md:gap-2 gap-1 mb-2">
                            <span class="flex items-center justify-center w-5 h-5">
                                <x-icon-location-outline-v2 />
                            </span>
                            <a href="{{ $mapUrl ? $mapUrl : '#' }}">
                                {{ $address }}
                            </a>
                        </li>
                    @endif
                    @if (!empty($user->profile->year_established))
                        <li class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm md:tracking-[-0.096px] tracking-[-0.084px] flex items-center md:gap-2 gap-1">
                            <span class="flex items-center justify-center w-5 h-5">
                                <x-icon-business-icon />
                            </span>
                            {{ __('In business since') }} {{ $user->profile->year_established }}
                        </li>
                    @endif
                </ul>
            @endif
        </div>
    </div>
    @if ($mapIframeUrl)
        <div class="flex items-center justify-center mt-6 md:h-auto h-[313px]">
            <iframe width="100%"
                height="200"
                frameborder="0"
                style="border:0"
                referrerpolicy="no-referrer-when-downgrade"
                class="rounded-xl w-full md:h-auto h-full object-cover object-center"
                src="{{ $mapIframeUrl }}"
                allowfullscreen>
            </iframe>
        </div>
    @endif
    <div class="mt-6 grid  grid-cols-2 gap-3">
        <a href="{{ route('member.show', ['slug' => $user->slug]) }}" class="secondary-btn">
            <x-icon-right-top-arrow />
            {{ __('View Seller Profile') }}
        </a>
        <a href="tel:{{ $user->profile->phone }}" class="text-sm font-bold leading-5 tracking-[-0.084px] text-black rounded-full btn-gradient transition-all duration-500 ease-in-out h-10 shadow-36xl! flex items-center justify-center gap-2.5">
            <span class="w-5 h-5 flex items-center justify-center">
                <x-icon-phone-icon />
            </span>
            {{ __('Call') }}
        </a>
    </div>
</div>
