@props(['user', 'reviewsStats'])
@php
    use Illuminate\Support\Str;
    $mapUrl = $user->mapUrl;
    $address = $user->address();
    $mapIframeUrl = $user->mapIframeUrl();
@endphp
<div class="bg-white rounded-3xl shadow-10xl border border-solid border-gray-1200 bg-shadow-5xl xl:p-6 p-4">
    <div class="relative">
        <div class="relative border border-solid border-gray-1200 rounded-2xl w-[72px] p-2.5 h-[72px] flex items-center justify-center">
            <x-frontend.member.profile.partials.profile-avatar :user="$user" />
            <span class="flex items-center justify-center absolute -right-3.5  -top-3.5">
                <x-icon-verify-icon />
            </span>
        </div>
    </div>
    <div class="">
        <h4 class="text-black-1200 font-medium text-xl leading-8">
            {{ $user->memberName() }}
        </h4>
        @if ($user->parentCategories(limit: 1)?->first()?->category_name)
            <a href="#" class="tags mt-3">
                {{ $user->parentCategories(limit: 1)?->first()?->category_name }}
            </a>
        @endif
        <div class="mt-3">
            @if (!empty($reviewsStats['average_rating']) && !empty($reviewsStats['total_reviews']))
                <ul class="flex items-center gap-[5px]">
                    @if (!empty($reviewsStats['average_rating']))
                        <x-frontend.review.partials.review-average-star-yellow :rating="$reviewsStats['average_rating'] ?? 4.91" />
                    @endif
                    @if (!empty($reviewsStats['total_reviews']))
                        <li class="ml-1.5">
                            <a class="flex items-center font-medium xl:text-sm text-xs tracking-[-0.096px] text-mid-gray underline underline-offset-2">
                                {{ $reviewsStats['total_reviews'] }}
                                {{ __('reviews') }}
                            </a>
                        </li>
                    @endif
                </ul>
            @endif
            @if ($user->address() || $user->profile?->year_established)
                <ul class="mt-3">
                    @if ($user->address())
                        <li class="text-mid-gray font-medium xl:text-sm text-xs tracking-[-0.096px] flex items-center gap-2 mb-2">
                            <span class="flex items-center justify-center w-5 h-5">
                                <x-icon-location-outline-v2 />
                            </span>
                            <a href="{{ $mapUrl ? $mapUrl : '#' }}">{{ $address }}</a>
                        </li>
                    @endif
                    @if (!empty($user->profile->year_established))
                        <li class="text-mid-gray font-medium xl:text-sm text-xs tracking-[-0.096px] flex items-center gap-2">
                            <span class="flex items-center justify-center w-5 h-5">
                                <x-icon-business-icon />
                            </span>
                            {{ Str::headline('In business since') }} {{ $user->profile->year_established }}
                        </li>
                    @endif
                </ul>
            @endif
        </div>
    </div>
    @if ($mapIframeUrl)
        <div class="flex items-center justify-center mt-6">
            <iframe width="100%"
                height="200"
                frameborder="0"
                style="border:0"
                referrerpolicy="no-referrer-when-downgrade"
                src="{{ $mapIframeUrl }}"
                allowfullscreen>
            </iframe>
        </div>
    @endif
    <div class="mt-6 lg:grid hidden grid-cols-2 gap-3">
        <a href="{{ route('member.show', $user->slug) }}" class="secondary-btn">
            {{ __('View Profile') }}
        </a>
        <a href="tel:{{ $user->phone }}" class="primary-btn mb-3">
            <x-icon-phone-icon />
            {{ __('Call') }}
        </a>
    </div>
</div>
