@props(['type' => 'Classified'])
<div class="bg-gray-1400 border border-solid border-gray-1200 rounded-2xl p-6">
    <div class="text-center border-b border-solid border-gray-1200/[0.3] pb-4">
        <h4 class="text-black-1200 font-medium text-xl leading-7">
            {{ $type }}
            {{ __('Ad Alert') }}
        </h4>
        <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px] mt-2">
            {{ __('Get the latest') }} {{ $type }} {{ __('ads delivered')}} <br/> {{ __('directly to your inbox!') }}
        </p>
    </div>
    <div class="pt-4">
        <form>
            <input type="text"
                class="text-black-1200 w-full mb-3 placeholder:text-gray-1500 text-sm font-normal tracking-[-0.084px] bg-white border border-solid border-gray-1200 rounded-full h-10 pl-3 focus:border-black-1200 focus:ring-black-1200"
                placeholder="Enter email here" />
            <a href="#" class="text-sm font-bold leading-5 tracking-[-0.084px] text-black rounded-full btn-gradient transition-all duration-500 ease-in-out h-10 shadow-35xl! flex items-center justify-center">{{ __('Set Ad Alert') }}</a>
        </form>
        <p class="text-mid-gray font-normal text-xs leading-4 text-center mt-4">{{ __('We respect your privacy. Unsubscribe anytime.') }}</p>
    </div>
</div>
