@php
    use Illuminate\Support\Str;
    $location = $user->primaryLocation ? $user->primaryLocation : null;
    $address = $user->address();
    $category = $user->parentCategories(1)->first();
    $mapUrl = $user->mapUrl;
    $average_rating = $reviewsStats['average_rating'] ?? 0;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
    $mapIframeUrl = $user->mapIframeUrl();
@endphp

<div class="p-4 bg-white rounded-3xl border border-solid border-gray-1200 bg-shadow-5xl xl:p-6">
    <!-- Map Image Section -->
    <div class="flex justify-center items-center">
        @if ($mapIframeUrl)
            <iframe width="100%"
                height="200"
                frameborder="0"
                style="border:0"
                referrerpolicy="no-referrer-when-downgrade"
                src="{{ $mapIframeUrl }}"
                allowfullscreen>
            </iframe>
        @endif
    </div>

    <!-- Rating and Reviews Section -->
    <div class="mt-6">
        @if (!empty($reviewsStats['average_rating']) && !empty($reviewsStats['total_reviews']))
            <ul class="flex items-center gap-[5px]">
                @if (!empty($reviewsStats['average_rating']))
                    <x-frontend.review.partials.review-average-star-yellow :rating="$reviewsStats['average_rating'] ?? 4.91" />
                @endif
                @if (!empty($reviewsStats['total_reviews']))
                    <li class="ml-1.5">
                        <a onclick="document.getElementById('profile-reviews-styled-tab').click()" class="cursor-pointer flex items-center font-medium xl:text-sm text-xs tracking-[-0.096px] text-mid-gray underline underline-offset-2">
                            {{ $rating_count }} {{ Str::headline('reviews') }}
                        </a>
                    </li>
                @endif

            </ul>
        @endif

        <!-- Location and Business Info -->
        <ul class="mt-3">
            @if (!empty($address))
                <li class="text-mid-gray font-medium xl:text-sm text-xs tracking-[-0.096px] flex items-center gap-2 mb-2">
                    <span class="flex justify-center items-center w-5 h-5">
                        <x-icon-location-outline-v2 />
                    </span>
                    <a href="{{ $mapUrl ? $mapUrl : '#' }}" class="inline-flex hover:text-primary-blue hover:underline">{{ $address }}</a>
                </li>
            @endif
            @if (!empty($user->profile->year_established))
                <li class="text-mid-gray font-medium xl:text-sm text-xs tracking-[-0.096px] flex items-center gap-2">
                    <span class="flex justify-center items-center w-5 h-5">
                        <x-icon-business-icon />
                    </span>
                    {{ Str::headline('In business since') }} {{ $user->profile->year_established }}
                </li>
            @endif
        </ul>
    </div>

    <!-- Action Buttons -->
    <div class="mt-6">
        @if (!empty($user->profile->phone))
            <a href="tel:{{ $user->profile->phone }}" class="mb-3 text-white primary-btn">
                <x-icon-phone-icon />
                {{ __('Call') }}
            </a>
        @endif
        @if (!empty($user->email))
            <x-frontend.includes.contact-modal-button :user="$user" class="secondary-btn">
                <x-icon-chat-icon-blue class="w-4 h-4" /> {{ __('Message us') }}
            </x-frontend.includes.contact-modal-button>
        @endif
    </div>

    <!-- Service Areas Section -->
    @if ($user->primaryLocation?->areas()->exists())
        <div class="mt-6">
            <h4 class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px]">{{ __('Service area') }}</h4>
            <div x-data="{ expanded: false }">
                <ul class="flex flex-wrap gap-2 max-w-[370px] w-full mt-3">
                    @foreach ($user->getAreas() as $area)
                        <li x-show="expanded || {{ $loop->index }} < 3"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform scale-95"
                            x-transition:enter-end="opacity-100 transform scale-100"
                            x-transition:leave="transition ease-in duration-150"
                            x-transition:leave-start="opacity-100 transform scale-100"
                            x-transition:leave-end="opacity-0 transform scale-95">
                            <a href="#" class="tags !border-transparent !h-7">{{ Str::headline($area->name) }}</a>
                        </li>
                    @endforeach
                </ul>

                @if (count($user->getAreas()) > 3)
                    <a href="javascript:void(0)"
                        @click.prevent="expanded = !expanded"
                        class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-5 text-primary-blue">
                        <span x-text="expanded ? '{{ __('Show less') }}' : '{{ __('Show all :count', ['count' => count($user->getAreas())]) }}'" class="transition-all duration-300"></span>
                        <x-icon-down-arrow2 class="transition-transform duration-200" x-bind:class="{ 'rotate-180': expanded }" />
                    </a>
                @endif
            </div>
        </div>
    @endif
</div>
