<div class="border-t border-solid border-gray-1200 pt-8 mt-8">
    <div class="flex items-center justify-between mb-5">
        <h6>{{ __('Sponsored Listings') }}</h6>
        <a href="{{ route("member.index",['sort' => 'featured-first']) }}" class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.096px] rounded-full bg-gray-1400 flex items-center justify-center h-10 w-[81px]">
            {{ __('View All') }}
        </a>
    </div>
    <div>
        @if ($sponsoredListings->isNotEmpty())
            @foreach ($sponsoredListings as $sponsoredListing)
                <x-frontend.member.listing.sponsored-card :sponsoredItem="$sponsoredListing" />
            @endforeach
        @else
            <x-frontend.includes.no-records-found-v1>
                <x-slot:icon>
                    <x-icon-search-icon />
                </x-slot>
                <x-slot:title>
                    {{ __('Sponsored Listings') }}
                </x-slot>
                <x-slot:description>
                    {{ __('No sponsored listings found') }}
                </x-slot>
            </x-frontend.includes.no-records-found-v1>
        @endif
    </div>
</div>
