@props(['job'])
@php
    $author = $job->author;
    $author_image = null;
    $author_logo = $author->getFirstMediaUrl('logo', 'small');
    if ($author?->getMedia('logo')->count() > 0) {
        $author_image = $author->getFirstMediaUrl('logo', 'small');
    } else {
        if ($author?->getMedia('avatar')->count() > 0) {
            $author_image = $author->getFirstMediaUrl('avatar', 'small');
        }
        $author_image = $author->getFirstMediaUrl('logo', 'small');
    }
@endphp
<div class="relative group hover:shadow-10xl mt-5 transition-all duration-500 ease-in-out bg-white border border-solid border-gray-1200 rounded-2xl p-6 xl:pt-6  lg:pt-[70px] pt-6 shadow-7xl flex items-center  flex-col">
    <ul class="flex items-center absolute 2xl:top-6 top-5 2xl:right-6 right-2 2xl:gap-3 gap-1">
        <li>
            <a href="#" class="group bg-white shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 transition-all duration-500 ease-in-out border border-solid border-gray-1200 w-9 h-9 rounded-full flex items-center justify-center">
                <x-icon-heart-circle-outline />
            </a>
        </li>
        <li>
            <a href="#" class="group bg-white shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 transition-all duration-500 ease-in-out border border-solid border-gray-1200 w-9 h-9 rounded-full flex items-center justify-center">

                <x-icon-share-icon />
            </a>
        </li>
        <li class="md:block hidden">
            <a href="#" class="secondary-btn 2xl:w-[110px] w-[100px] !h-9">
                <x-icon-right-top-arrow />
                {{ __('View Job') }}
            </a>
        </li>
    </ul>
    <div class="w-full flex xl:flex-row flex-col xl:items-center items-start md:gap-6 gap-4">
        @if ($author_image)
            <div class="relative border border-solid border-gray-1200 rounded-2xl md:w-[100px] p-2.5 w-[72px] md:h-[100px] h-[72px] flex items-center justify-center">
                <img src="{{ $author_image }}" alt="{{ $author->name }}" class="w-full h-full object-cover object-center">
            </div>
        @endif
        <div class="flex-1 w-full">
            <h4 class="text-black-1200 font-medium xl:text-xl md:text-base text-xl leading-7 flex md:flex-row flex-col-reverse md:items-center items-start 2xl:gap-3 gap-1.5">
                {{ str()->limit($job->job_title, 20) }}
                @if ($job->is_new)
                    <span class="inline-flex items-center justify-center font-medium text-xs  bg-black-1200 px-[9px] text-white rounded-full h-6">
                        {{ __('Newly Listed') }}
                    </span>
                @endif
            </h4>
            <p class="text-sm font-medium leading-5 tracking-[-0.096px] text-black-1200 mt-1">
                {{ $job->user->memberName() }}
            </p>
            <ul class="mt-3 flex flex-wrap items-start">
                @if ($job->jobTypeName())
                    <li class="text-mid-gray font-medium text-xs leading-4 pr-2">
                        {{ $job->jobTypeName() }}
                    </li>
                @endif
                @if ($job->workMode())
                    <li class="text-mid-gray font-medium text-xs leading-4 pr-2 {{ $job->work_mode ? 'border-l border-solid border-gray-1200 px-2' : '' }}">
                        {{ $job->workMode() }}
                    </li>
                @endif
                @if ($job->jobCarerLevel())
                    <li class="text-mid-gray font-medium text-xs leading-4 border-l border-solid border-gray-1200 px-2">
                        {{ $job->jobCarerLevel() }}
                    </li>
                @endif
                @if ($job->saleryRange())
                    <li class="text-mid-gray font-medium text-xs leading-4 border-l border-solid border-gray-1200 px-2">
                        {{ $job->saleryRange() }}
                    </li>
                @endif
                @if ($job->jobRole())
                    <li class="text-mid-gray font-medium text-xs leading-4 border-l border-solid border-gray-1200 px-2">
                        {{ $job->jobRole() }}
                    </li>
                @endif
                @if ($job->jobIndustry())
                    <li class="text-mid-gray font-medium text-xs leading-4 border-l border-solid border-gray-1200 pl-2">
                        {{ $job->jobIndustry() }}
                    </li>
                @endif
            </ul>
            <ul class="flex xl:flex-nowrap flex-wrap md:items-center items-start mt-2 md:gap-0 gap-2">
                @if ($job->address())
                    <li class="text-mid-gray md:mb-0 mb-2 font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:pr-2">
                        <span class="flex items-center justify-center w-5 h-5">
                            <x-icon-location-outline-v2 />
                        </span>
                        {{ $job->address('short') }}
                    </li>
                @endif
                @if ($job->postedDate())
                    <li class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:border-l border-solid border-gray-1200 md:px-2">
                        <span class="flex items-center justify-center w-5 h-5">
                            <x-icon-business-icon />
                        </span>
                        {{ __('Posted:') }} {{ $job->postedDate() }}
                    </li>
                @endif
                @if ($job->deadlineDate())
                    <li class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:border-l border-solid border-gray-1200 md:pl-2">
                        <span class="flex items-center justify-center w-5 h-5">
                            <x-icon-clock-icon />
                        </span>
                        {{ __('Deadline:') }} {{ $job->deadlineDate() }}
                    </li>
                @endif
            </ul>
        </div>
    </div>
    <div class="md:hidden mt-6 w-full">
        <a href="#" class="secondary-btn w-full !h-9">
            <x-icon-right-top-arrow />
            {{ __('View Job') }}
        </a>
    </div>
</div>
