@props(['team'])
<div>
    <a href="javascript:void(0)"
        x-data="{ loading: false }"
        x-on:click="Livewire.dispatch('openModal', { component: 'frontend.team-member.modal.team-member-detail', arguments: { member: '{{ $team->uuid }}' }});"
        class="flex overflow-hidden relative flex-col p-6 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out group hover:shadow-10xl border-gray-1200 shadow-7xl">
        <x-frontend.includes.modal-element-loading class="team-detail-overlay-{{ $team->uuid }} rounded-md" />
        <div class="flex flex-col items-center">
            @if ($team->getFirstMediaUrl('featured_image'))
                <img src="{{ $team->getFirstMediaUrl('featured_image', 'thumb') }}"
                    alt="{{ $team->name }}"
                    class="rounded-xl w-full h-[166px] object-cover object-center" />
            @endif
        </div>
        <div class="pt-4">
            <div class="flex justify-between items-center mb-1.5">
                @if (!empty($team->team_member_role))
                    <span class="tags !border-0">{{ ucfirst($team->team_member_role) }}</span>
                @endif
                <span class="flex justify-center items-center opacity-0 transition-all duration-500 ease-in-out group-hover:opacity-100">
                    <x-icon-right-top-arrow />
                </span>
            </div>
            <h4 class="font-medium text-base leading-6 tracking-[-0.176px]  text-black-1200">
                {{ str()->limit($team->first_name . ' ' . $team->last_name, 20) }}
            </h4>
            <p class="text-sm font-normal leading-5 tracking-[-0.096px] mt-1.5 text-mid-gray line-clamp-2">
                {!! tiptap_converter()->asText(str()->limit($team->description, 100)) !!}
            </p>
        </div>
    </a>
</div>
