@props(['video'])
@php
    use ProtoneMedia\LaravelFFMpeg\Support\FFMpeg;
    use Illuminate\Support\Facades\Storage;
    use Illuminate\Support\Number;

    $videoFileUrl = $video->getFirstMediaUrl('video', 'thumb');
    $media = $video->media('video')->first();
    dump($media->getPath());
    $duration = 0;

    if ($media) {
        $videoPath = $media->getPath();
        $duration = FFMpeg::fromDisk($media->disk)->open($media->getPathRelativeToRoot())->getDurationInSeconds();
        $duration = gmdate('i:s', $duration);
    }
@endphp
<div class="flex flex-col p-6 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out cursor-pointer group hover:shadow-10xl border-gray-1200 shadow-7xl">
    <div class="flex relative flex-col items-center">
        @if ($videoFileUrl)
            <img src="{{ $videoFileUrl }}"
                alt=""
                class="rounded-xl w-full h-[166px] object-cover object-center" />
        @endif
        @if ($duration)
            <span class="absolute right-3 bottom-3 text-white text-[13px] font-bold leading-[130%] h-5 rounded-[40px] bg-blue-1500/[0.3] backdrop-blur-[10px] inline-flex items-center justify-center px-1.5">{{ $duration }}</span>
        @endif

        <a href="javascript:void(0)"
            onclick="Livewire.dispatch('openModal', { component: 'frontend.member.modal.play-video-modal', arguments: { video: {{ $video->id }} }})"
            class="flex absolute top-1/2 left-1/2 invisible z-10 justify-center items-center w-10 h-10 rounded-full opacity-0 transition-all duration-500 ease-in-out -translate-x-1/2 -translate-y-1/2 group-hover:opacity-100 group-hover:visible bg-gray-1400 shadow-11xl">
            <x-icon-play-fill />
        </a>

        <div class="absolute left-0 group-hover:opacity-100 opacity-0 group-hover:visible invisible  transition-all duration-500 ease-in-out top-0 flex items-center justify-center w-full h-full rounded-xl bg-black-1400/[0.24]">
        </div>
    </div>
    <div class="pt-4">
        <div class="flex gap-2 items-center">
            <span class="flex justify-center items-center p-1 w-8 h-8 rounded-full border border-solid border-gray-1200">
                <x-frontend.member.profile.partials.profile-avatar :user="$video->user" class="rounded-full" />
            </span>
            <div class="flex-1 w-full">
                <h4 class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px]">
                    {{ str()->limit($video->video_title, 20) }}
                </h4>
                @if ($video->user)
                    <p class="text-mid-gray font-medium text-[11px] leading-3 tracking-[0.32px] mt-1">
                        {{ $video->user->memberName() }}
                    </p>
                @endif
                <ul class="flex gap-1.5 items-center mt-2">
                    <li class="text-mid-gray font-medium text-[11px] leading-3 tracking-[0.32px]">
                        {{ $video->views }} {{ __('views') }}
                    </li>
                    <li><span class="flex items-center justify-center rounded-full bg-gray-1500 w-[3px] h-[3px]"></span>
                    </li>
                    <li class="text-mid-gray font-medium text-[11px] leading-3 tracking-[0.32px]">
                        {{ $video->created_at->diffForHumans() }}
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
