@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}&libraries=places,marker"
        async
        defer></script>
@endpush

<div>
    {{-- xl:mt-[87px] mt-[60px] --}}
    <div class="relative z-50 p-3 bg-gray-1400">
        <div style="--bg-banner-desktop: url('{{ $lead_bg_img }}');" class="rounded-3xl bg-[image:var(--bg-banner-desktop)] bg-cover bg-center bg-no-repeat lg:pt-[116px] md:pt-[60px] py-12 md:pb-[230px]">
            <div class="max-w-[1269px] w-full  mx-auto md:px-4 px-6">
                <div class="max-w-[750px] w-full">
                    <h2 class="text-white font-normal lg:text-[64px] text-5xl lg:leading-[64px] md:leading-[54px] leading-[48px] md:tracking-[-0.32px] tracking-[-0.48px]">
                        {!! $heading !!}
                    </h2>
                    <div class="text-white lg:text-lg md:text-base text-lg leading-6 md:tracking-[-0.24px] tracking-[-0.27px]  max-w-[735px] md:mt-3.5 mt-4">
                        {!! $description !!}
                    </div>
                    <div class="px-3 py-5 mt-10 rounded-2xl md:p-5 gradient3">
                        <form action="{{ route('lead.lead-form') }}" method="get">
                            <div class="flex flex-col gap-3 items-center mb-3 md:flex-row">
                                <div class="relative flex-1 w-full" x-data="{
                                    initEstimateAutocomplete() {
                                        const checkAndInit = () => {
                                            if (window.google && window.google.maps && window.google.maps.places && window.ESPGoogleMaps) {
                                                const result = ESPGoogleMaps.initAutocomplete({
                                                    inputField: '#estimate-address-input',
                                                    latitudeField: '#estimate-lat',
                                                    longitudeField: '#estimate-lng',
                                                    cityField: '#estimate-city',
                                                    stateField: '#estimate-state',
                                                    stateCodeField: '#estimate-state-code',
                                                    countryField: '#estimate-country',
                                                    countryCodeField: '#estimate-country-code',
                                                    types: ['geocode'],
                                                    onPlaceChanged: function (place) {
                                                        const inputEl = document.getElementById('estimate-address-input');
                                                        if (inputEl && (place?.formatted_address || place?.name)) {
                                                            inputEl.value = place.formatted_address || place.name;
                                                        }
                                                    }
                                                });
                                                return true;
                                            }
                                            return false;
                                        };

                                        if (!checkAndInit()) {
                                            const interval = setInterval(() => {
                                                if (checkAndInit()) {
                                                    clearInterval(interval);
                                                }
                                            }, 500);
                                            setTimeout(() => clearInterval(interval), 10000);
                                        }
                                    }
                                }" x-init="setTimeout(() => initEstimateAutocomplete(), 100)">
                                    <input type="text"
                                        name="address"
                                        id="estimate-address-input"
                                        class="placeholder:text-mid-gray/[0.8] pl-12 text-mid-gray font-normal text-base leading-6 bg-white rounded-full h-[56px] w-full focus:ring-0 focus:ring-transparent"
                                        placeholder="{{ __('Enter property address e.g Vancouver, BC etc') }}" />
                                    <span class="absolute top-1/2 -translate-y-1/2 left-4 flex items-center justify-center w-6 h-6 text-[#525866]">
                                        <x-icon-location-outline-v2 />
                                    </span>
                                    <input type="hidden"
                                        id="estimate-lat"
                                        name="lat" />
                                    <input type="hidden"
                                        id="estimate-lng"
                                        name="lng" />
                                    <input type="hidden"
                                        id="estimate-city"
                                        name="city" />
                                    <input type="hidden"
                                        id="estimate-state"
                                        name="state" />
                                    <input type="hidden"
                                        id="estimate-state-code"
                                        name="state_code" />
                                    <input type="hidden"
                                        id="estimate-country"
                                        name="country" />
                                    <input type="hidden"
                                        id="estimate-country-code"
                                        name="country_code" />
                                </div>
                                <button type="submit" class="font-medium text-[19.6px] leading-7 tracking-[-0.096px] text-white bg-primary-blue hover:bg-blue-1300 transition-all duration-500 ease-in-out rounded-full h-[56px] md:w-[229px] w-full flex items-center justify-center">
                                    {{ __('Request an estimate') }}
                                </button>
                            </div>
                            <p class="text-white sm:max-w-full max-w-[255px] mx-auto font-normal text-base leading-6 md:text-left text-center">
                                {{ __('Your request is sent securely to our office and kept completely confidential') }}
                            </p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!------ BANNER SEC ------>
    @if (!empty($expertise))
        <section class="pt-6 pb-12 bg-gray-1400 md:pb-20 md:pt-0">
            <div class="max-w-[1288px] w-full  mx-auto md:px-4 px-6 md:mt-[-160px] relative z-[1000]">
                <div class="grid grid-cols-1 gap-5 lg:grid-cols-3 md:grid-cols-2">
                    @foreach ($expertise as $item)
                        <div class="text-center rounded-3xl border-[10px] border-solid border-white/[0.24]">
                            <div class="bg-white rounded-2xl sm:p-6 p-[22px]">
                                <span class="flex items-center text-white justify-center mx-auto w-[52px] h-[52px] border border-solid border-blue-2000 rounded-[14px] gradient shadow-16xl">
                                    <x-icon-location-fill-v2 />
                                </span>
                                <h4 class="text-black-1200 my-5 font-medium xl:text-lg md:text-base text-lg leading-6 md:tracking-[-0.24px] tracking-[-0.27px]">
                                    {!! $item['title'] !!}
                                </h4>
                                <div class="text-mid-gray md:line-clamp-5 md:max-w-[285px] w-full mx-auto font-normal xl:text-lg md:text-base text-lg leading-6 md:tracking-[-0.24px] tracking-[-0.27px]">
                                    {!! $item['description'] !!}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
</div>
