<div class="bg-white md:p-3">
    <div class="bg-gray-1800 py-6 md:py-20">
        <div class="max-w-[1232px] w-full  mx-auto md:px-4 px-6">
            <div class="text-center">
                <h3 class="xl:text-5xl lg:text-4xl md:flex-nowrap flex-wrap md:text-[40px] text-[32px] text-black-1200 font-inter font-normal lg:leading-[56px] md:leading-[48px] leading-10 md:tracking-[-0.32px] tracking-[-0.64px] inline-flex items-center sm:justify-start justify-center sm:max-w-full max-w-[321px] sm:mx-0 mx-auto gap-x-3">
                    {!! $heading !!}
                </h3>
                @if (!empty($description))
                    <div class="text-mid-gray font-normal md:text-lg text-base leading-6 md:tracking-[-0.27px] tracking-[-0.24px] mt-1.5 sm:max-w-full max-w-[200px] sm:mx-0 mx-auto">
                        {!! $description !!}
                    </div>
                @endif
            </div>
            <div class="max-w-[1000px] w-full mx-auto md:mt-16 mt-6">
                <div id="accordion-collapse" data-accordion="collapse">
                    @if (!empty($faqs) && count($faqs))
                        @foreach ($faqs as $key => $faq)
                            <div class="p-4 md:mb-4 mb-2 rounded-2xl bg-white border border-solid border-gray-1200" x-data="{ open: false }">
                                <h2 id="accordion-heading-faq-{{ $key }}"
                                    class="flex items-center text-left justify-between cursor-pointer w-full !text-black-1200 font-medium md:text-lg text-base leading-6 md:tracking-[-0.27px] tracking-[-0.24px]"
                                    :aria-expanded="open.toString()"
                                    aria-controls="accordion-body-faq-{{ $key }}"
                                    x-on:click="open = !open">
                                    <button type="button"
                                        class="flex items-center text-left justify-between w-full focus:ring-0 focus:ring-transparent pointer-events-none"
                                        data-accordion-target="#accordion-body-faq-{{ $key }}">
                                        <span class="flex items-center flex-1">
                                            {!! data_get($faq, 'question') !!}
                                        </span>
                                        <span class="flex justify-center items-center w-8 h-8 rounded-full bg-gray-1400">
                                            <svg data-accordion-icon
                                                width="10"
                                                class="w-3 h-3 shrink-0 transition-transform duration-200"
                                                aria-hidden="true"
                                                :class="open ? 'rotate-180' : ''"
                                                height="6"
                                                viewBox="0 0 10 6"
                                                fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M4.773 3.7125L8.4855 0L9.546 1.0605L4.773 5.8335L0 1.0605L1.0605 0L4.773 3.7125Z" fill="#525866" />
                                            </svg>

                                        </span>
                                    </button>
                                </h2>
                                <div id="accordion-body-faq-{{ $key }}"
                                    x-cloak
                                    x-show="open"
                                    x-transition.opacity.duration.200ms
                                    aria-labelledby="accordion-heading-faq-{{ $key }}">
                                    <div class="md:mt-3 mt-1">
                                        <p class="md:text-base text-sm font-normal leading-6 text-mid-gray">
                                            {!! data_get($faq, 'answer') !!}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif

                </div>
            </div>
        </div>
    </div>
</div>
