<section style="--bg-banner-desktop: url('{{ $banner_image }}'); --bg-banner-mobile: url('{{ $banner_image_mobile }}');" class="page-widget-section sm:bg-[image:var(--bg-banner-desktop)] bg-[image:var(--bg-banner-mobile)] bg-cover bg-center bg-no-repeat xl:pt-[268px] md:pt-[150px] pt-[112px] pb-12 xl:pb-[180px] md:pb-[50px] min-h-[500px] ">
    <div class="max-w-[1232px] w-full  mx-auto md:px-4 px-6">
        <div class="max-w-[720px] w-full mx-auto md:text-center text-left">
            <h3 class="md:text-[64px] text-5xl md:text-center text-left font-normal  text-white md:leading-[56px] leading-[48px] md:tracking-[-0.32px] tracking-[-0.8px]">
                {!! $heading !!}
            </h3>
        </div>
        <div x-data="{ activeTab: '{{ $defaultTab }}', routes: @js($searchRoutes) }" class="mt-10 lg:mt-16">
            @if (!empty($orderedTabs))
                <div class="overflow-x-auto mb-5 text-center rounded-full md:overflow-x-hidden">
                    <div class="inline-flex overflow-x-auto justify-center items-center rounded-full md:overflow-x-hidden">
                        <ul class="bg-white/[0.16] md:w-full w-[610px] p-1 inline-flex items-center gap-2 rounded-full">
                            @foreach ($orderedTabs as $tab)
                                <li>
                                    <a href="javascript:void(0)"
                                        id='tab-{{ $tab }}'
                                        @click.prevent="activeTab = '{{ $tab }}'"
                                        :class="activeTab === '{{ $tab }}' ? 'bg-white/[0.16] text-white opacity-100' : 'opacity-80 hover:bg-white/[0.16] hover:opacity-100'"
                                        class="connect-link text-white rounded-full h-9 px-2.5 text-sm font-medium leading-5 tracking-[-0.096px] gap-2 flex items-center justify-center ">
                                        <span class="flex justify-center items-center w-5 h-5">
                                            @if ($tab === 'member_profile')
                                                <x-icon-building-icon />
                                            @elseif ($tab === 'jobs')
                                                <x-icon-job-icon />
                                            @elseif ($tab === 'classifieds')
                                                <x-icon-classifieds-icon />
                                            @elseif ($tab === 'manufacturers_suppliers')
                                                <x-icon-truck-icon />
                                            @endif
                                        </span>
                                        {{ $availableTabs[$tab]['label'] }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            @endif
            <form :action="routes[activeTab] ?? '{{ $defaultSearchRoute }}'" method="GET">
                <div class="max-w-[830px] w-full mx-auto border-[10px] border-solid border-white/[0.24] bg-white/[0.16] px-6 md:py-3.5 py-4 md:rounded-full rounded-3xl">
                    <div class="relative">
                        <div class="grid grid-cols-1 mb-5 md:grid-cols-2 md:mb-0">
                            <div class="flex items-start gap-1 md:pb-0 pb-6 md:border-r md:border-b-0 border-b border-solid border-white/[0.24]">
                                <span class="flex items-center justify-center w-[18px] h-[18px]">
                                    <x-icon-search-home-icon />
                                </span>
                                <div class="flex-1 w-full">
                                    <label class="text-white text-sm font-medium leading-5 tracking-[-0.096px] block mb-0.5">
                                        {{ $search_title }}
                                    </label>
                                    <input type="text"
                                        name="q"
                                        class="placeholder:text-white/[0.8] text-white text-base font-normal leading-6 bg-transparent border-0 focus:ring-0 p-0 w-full"
                                        placeholder="{{ $search_placeholder }}" />
                                </div>
                            </div>
                            <div class="flex gap-1 items-start pt-6 pl-0 md:pl-4 md:pt-0">
                                <span class="flex items-center justify-center w-[18px] h-[18px] text-white">
                                    <x-icon-location-outline-v2 />
                                </span>
                                <div class="flex-1 w-full">
                                    <label class="text-white text-sm font-medium leading-5 tracking-[-0.096px] block mb-0.5">
                                        {{ $location_title }}
                                    </label>
                                    <input type="text"
                                        class="placeholder:text-white/[0.8] text-white text-base font-normal leading-6 bg-transparent border-0 focus:ring-0 p-0"
                                        placeholder="{{ $location_placeholder }}" />
                                </div>
                            </div>
                        </div>
                        <button type="submit"  class="flex -right-3 top-1/2 gap-2.5 justify-center items-center w-full h-12 bg-white rounded-full md:absolute md:-translate-y-1/2 md:w-12">
                            <svg class="md:w-[21px] md:h-[21px] w-[15px] h-[15px]"
                                viewBox="0 0 16 16"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M7.25 0.5C10.976 0.5 14 3.524 14 7.25C14 10.976 10.976 14 7.25 14C3.524 14 0.5 10.976 0.5 7.25C0.5 3.524 3.524 0.5 7.25 0.5ZM7.25 12.5C10.1502 12.5 12.5 10.1502 12.5 7.25C12.5 4.349 10.1502 2 7.25 2C4.349 2 2 4.349 2 7.25C2 10.1502 4.349 12.5 7.25 12.5ZM13.6137 12.5532L15.7355 14.6742L14.6742 15.7355L12.5532 13.6137L13.6137 12.5532Z" fill="#0E121B" />
                            </svg>
                            <span class="md:hidden flex items-center text-mid-gray text-sm font-medium tracking-[-0.6%]">Search</span>
                        </button>
                    </div>
                </div>
            </form>
            @if (!empty($popular_searches))
                <div class="flex md:flex-row flex-col items-center justify-center lg:gap-3 md:gap-1 gap-[17px] md:mt-5 mt-6">
                    <p class="text-white text-sm font-normal leading-5 tracking-[-0.6%]">{{ __('Popular Searches:') }}</p>
                    <ul class="flex flex-wrap gap-3 justify-center items-center md:flex-nowrap md:justify-start lg:gap-3 md:gap-1">
                        @foreach ($popular_searches as $popular_search)
                            <li>
                                <a href="{{ $popular_search['link'] }}" class="text-white opacity-80 text-xs font-medium leading-4 inline-flex items-center rounded-full bg-white/[0.16] h-7 px-[11px]">{{ $popular_search['title'] }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>
</section>