@php
    $firstTab = $orderedTabs[0] ?? null;
@endphp

<section style="--bg-banner-desktop: url('{{ $banner_image }}'); --bg-banner-mobile: url('{{ $banner_image_mobile }}');" class="page-widget-section sm:bg-[image:var(--bg-banner-desktop)] bg-[image:var(--bg-banner-mobile)] bg-cover bg-center bg-no-repeat xl:py-[210px] lg:py-[150px] md:py-[100px] py-[160px] md:h-auto h-[920px]">
    <div class="max-w-[1232px] w-full  mx-auto md:px-4 px-6">
        <div class="w-full text-center">
            <h3 class="xl:text-[64px] md:text-[56px] text-[32px] font-normal  text-white md:leading-[56px] leading-10 md:tracking-[-1.28px] tracking-[-0.64px] sm:max-w-[720px] max-w-[281px] mx-auto">
                {!! $heading !!}
            </h3>
        </div>
        <div class="md:mt-10 mt-6 max-w-[807px] w-full mx-auto" x-data="{ activeTab: '{{ $defaultTab }}', searchRoute: '{{ $defaultSearchRoute }}' }">
            @if (!empty($orderedTabs))
                <div class="hidden md:block">
                    <div class="flex flex-wrap text-sm font-medium text-center"
                        id="hero-desktop-tabs-menu"
                        data-tabs-toggle="#hero-desktop-tabs-menu-content">
                        <ul class="inline-flex items-center">
                            @foreach ($orderedTabs as $tab)
                                <li role="presentation">
                                    <a href="javascript:void(0)"
                                        @click="activeTab = '{{ $tab }}'; searchRoute = '{{ $searchRoutes[$tab] ?? route('member.index') }}'"
                                        :class="activeTab === '{{ $tab }}' ? 'bg-blue-2100 text-white hover:text-white h-11 px-5 text-sm font-medium leading-5 tracking-[-0.084px] gap-2 flex items-center justify-center rounded-t-[20px]' : 'text-white hover:text-white hover:opacity-100 opacity-80 hover:bg-white/[0.16] h-11 px-5 text-sm font-medium leading-5 tracking-[-0.084px] gap-2 flex items-center justify-center rounded-t-[20px]'">
                                        {{-- connect-link rounded-t-[20px] text-white hover:text-white hover:opacity-100 h-11 px-5 text-sm font-medium leading-5 tracking-[-0.084px] gap-2 flex items-center justify-center --}}
                                        <span class="flex justify-center items-center w-5 h-5">
                                            @if ($tab === 'find_company')
                                                <x-icon-building-icon />
                                            @elseif($tab === 'jobs')
                                                <x-icon-job-icon />
                                            @elseif($tab === 'classifieds')
                                                <x-icon-classifieds-icon />
                                            @elseif($tab === 'suppliers' || $tab === 'manufactures')
                                                <x-icon-truck-icon />
                                            @endif
                                        </span>
                                        {{ $availableTabs[$tab]['label'] ?? ucfirst(str_replace('_', ' ', $tab)) }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="block -mb-px md:hidden">
                    <button id="hero-mobile-menu-button"
                        data-dropdown-toggle="hero-mobile-menu"
                        class="text-white bg-blue-2100 max-w-[203px] w-full justify-between focus:ring-0 focus:outline-none focus:ring-transparent font-medium  text-sm pl-4 pr-5 py-3 text-center inline-flex items-center gap-2 rounded-t-[20px]"
                        type="button">
                        @if ($firstTab)
                            <p class="flex gap-1 items-center">
                                <span class="flex justify-center items-center w-5 h-5">
                                    @if ($firstTab === 'find_company')
                                        <x-icon-building-icon />
                                    @elseif($firstTab === 'jobs')
                                        <x-icon-job-icon />
                                    @elseif($firstTab === 'classifieds')
                                        <x-icon-classifieds-icon />
                                    @elseif($firstTab === 'manufactures' || $firstTab === 'suppliers')
                                        <x-icon-truck-icon />
                                    @endif
                                </span>
                                {{ $availableTabs[$firstTab]['label'] ?? ucfirst(str_replace('_', ' ', $firstTab)) }}
                            </p>
                        @endif
                        <span class="flex justify-center items-center w-5 h-5">
                            <svg class="w-2.5 h-2.5"
                                aria-hidden="true"
                                xmlns="http://www.w3.org/2000/svg"
                                fill="none"
                                viewBox="0 0 10 6">
                                <path stroke="currentColor"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="m1 1 4 4 4-4" />
                            </svg>
                        </span>
                    </button>
                    <!-- Dropdown menu -->
                    <div id="hero-mobile-menu" class="z-10 hidden bg-blue-2100 w-[195px] !-ml-1">
                        <div id="hero-mobile-tabs-menu" data-tabs-toggle="#hero-mobile-tabs-menu-content">
                            <ul aria-labelledby="hero-mobile-menu-button">
                                @foreach ($orderedTabs as $tab)
                                    <li role="presentation">
                                        <a href="javascript:void(0)"
                                            @click="activeTab = '{{ $tab }}'; searchRoute = '{{ $searchRoutes[$tab] ?? route('member.index') }}'"
                                            :class="activeTab === '{{ $tab }}' ? 'bg-white/[0.16] text-white hover:text-white h-11 px-5 text-sm font-medium leading-5 tracking-[-0.084px] gap-2 flex items-center justify-start' : 'text-white hover:text-white hover:opacity-100 opacity-80 hover:bg-white/[0.16] h-11 px-5 text-sm font-medium leading-5 tracking-[-0.084px] gap-2 flex items-center justify-start'">
                                            {{-- class="connect-link  text-white hover:text-white hover:opacity-100 h-11 px-5 text-sm font-medium leading-5 tracking-[-0.084px] gap-2 flex items-center justify-start" --}}
                                            <span class="flex justify-center items-center w-5 h-5">
                                                @if ($tab === 'find_company')
                                                    <x-icon-building-icon />
                                                @elseif($tab === 'jobs')
                                                    <x-icon-job-icon />
                                                @elseif($tab === 'classifieds')
                                                    <x-icon-classifieds-icon />
                                                @elseif($tab === 'manufactures' || $tab === 'suppliers')
                                                    <x-icon-truck-icon />
                                                @endif
                                            </span>
                                            {{ $availableTabs[$tab]['label'] ?? ucfirst(str_replace('_', ' ', $tab)) }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            @endif
            <div id="hero-desktop-tabs-menu-content">
                <form :action="searchRoute" method="GET">
                    <div class="w-full bg-blue-2100 md:p-5 p-3" :class="activeTab === '{{ $orderedTabs[0] }}'
                        ?
                        'md:rounded-b-[56px] md:rounded-tr-[56px] rounded-b-[40px] rounded-tr-[40px]' :
                        'md:rounded-[56px] rounded-b-[40px] rounded-tr-[40px]'">
                        <div class="relative flex md:flex-row flex-col md:items-center items-strat gap-5 py-4 pr-4 pl-6 md:rounded-full rounded-[32px] bg-white">
                            <div class="grid grid-cols-1 md:gap-3.5 gap-5 flex-1 md:grid-cols-2">
                                <div class="flex items-start gap-1">
                                    <span class="flex items-center justify-center w-[18px] h-[18px]">
                                        <x-icon-search-sm-v1 />
                                    </span>
                                    <div class="flex-1 w-full">
                                        <label class="text-black md:text-base text-sm font-bold leading-5 md:tracking-[-0.096px] tracking-[-0.084px] block mb-0.5">
                                            {{ $search_title }}
                                        </label>
                                        <input type="text"
                                            name="q"
                                            class="placeholder:text-gray-1700/[0.8] text-gray-1700 w-full font-inter md:text-base text-sm font-normal leading-6 bg-transparent border-0 focus:ring-0 p-0"
                                            placeholder="{{ $search_placeholder }}" />
                                    </div>
                                </div>
                                <div class="flex gap-1 items-start">
                                    <span class="flex items-center justify-center w-[18px] h-[18px]">
                                        <x-icon-location-outline-sm-v1 />
                                    </span>
                                    <div class="flex-1 w-full">
                                        <label class="text-black md:text-base text-sm font-bold leading-5 md:tracking-[-0.096px] tracking-[-0.084px] block mb-0.5">{{ $location_title }}</label>
                                        <input type="text"
                                            name="location"
                                            id="estimate-address-input"
                                            class="placeholder:text-gray-1700/[0.8] text-gray-1700 w-full font-inter md:text-base text-sm font-normal leading-6 bg-transparent border-0 focus:ring-0 p-0"
                                            placeholder="{{ $location_placeholder }}" />
                                        <input type="hidden"
                                            id="estimate-lat"
                                            name="lat" />
                                        <input type="hidden"
                                            id="estimate-lng"
                                            name="lng" />
                                        <input type="hidden"
                                            id="estimate-city"
                                            name="city" />
                                        <input type="hidden"
                                            id="estimate-state"
                                            name="state" />
                                        <input type="hidden"
                                            id="estimate-state-code"
                                            name="state_code" />
                                        <input type="hidden"
                                            id="estimate-country"
                                            name="country" />
                                        <input type="hidden"
                                            id="estimate-country-code"
                                            name="country_code" />
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="flex shadow-22xl justify-center items-center w-full h-12 btn-gradient rounded-full md:w-12">
                                <svg class="w-[21px] h-[21px]"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.25 0.5C10.976 0.5 14 3.524 14 7.25C14 10.976 10.976 14 7.25 14C3.524 14 0.5 10.976 0.5 7.25C0.5 3.524 3.524 0.5 7.25 0.5ZM7.25 12.5C10.1502 12.5 12.5 10.1502 12.5 7.25C12.5 4.349 10.1502 2 7.25 2C4.349 2 2 4.349 2 7.25C2 10.1502 4.349 12.5 7.25 12.5ZM13.6137 12.5532L15.7355 14.6742L14.6742 15.7355L12.5532 13.6137L13.6137 12.5532Z" fill="#000000" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            @if (!empty($popular_searches))
                <div class="gap-3.5 mt-5 md:gap-4">
                    <p class="text-white mb-3  md:text-left text-center text-sm font-normal leading-5 tracking-[-0.084px]">
                        {{ __('Popular Searches:') }}
                    </p>
                    <ul class="flex flex-wrap gap-3 justify-center items-center md:flex-nowrap md:justify-start lg:gap-3 md:gap-1">
                        @foreach ($popular_searches as $search)
                            <li>
                                <a href="{{ isset($search['url']) ? $search['url'] : '#' }}" class="services-tag text-white/80 md:text-sm text-xs font-medium md:leading-4 leading-3.5 inline-flex items-center rounded-lg bg-white/[0.16] h-10 xl:px-5 px-4 hover:bg-white hover:text-blue-2300 transition-all duration-500 ease-in-out">
                                    {{ $search['title'] }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>
</section>
