<div class="p-3">
    <div style="--bg-request-estimate-desktop: url('{{ $desktop_background_image }}')" class="bg-[image:var(--bg-request-estimate-desktop)] bg-cover bg-center bg-no-repeat rounded-3xl md:pt-[106px] md:pb-[105px] py-6" >
        <div class="max-w-[1288px] w-full mx-auto md:px-4 px-6">
            <div class="flex flex-col gap-8 items-start lg:flex-row xl:gap-16 md:gap-6">
                <div class="flex-1 w-full">
                    <div class="">
                        <span class="text-white mb-4 font-medium text-xs leading-4 bg-blue-1200/[0.16] border border-solid border-white/[0.5] inline-flex items-center justify-center rounded-full h-6 px-2">
                            {{ __('Complete Well and Pump Quote') }}
                        </span>
                        @if ($title)
                            <h3 class="xl:text-5xl lg:text-4xl md:text-[40px] text-[32px] text-left font-normal text-white lg:leading-[56px] md:leading-[48px] leading-10 md:tracking-[-0.32px] tracking-[-0.64px]">
                                {!! $title !!}
                            </h3>
                        @endif
                        @if ($description)
                            <div class="md:text-lg text-base font-normal mt-1.5 leading-6 tracking-[-0.24px] text-white sm:max-w-full md:max-w-[720px] max-w-[321px] w-full">
                                {!! $description !!}
                            </div>
                        @endif
                    </div>
                    @if (!empty($features))
                        <div class="grid md:grid-cols-2 grid-cols-1 md:gap-5 gap-3 max-w-[767px] w-full md:mt-10 mt-4">
                            @foreach ($features as $feature)
                                <div class="flex items-center gap-4 px-5 min-h-[100px] md:py-[18px] py-[22px] rounded-xl border border-solid border-white/16 bg-cover bg-center bg-no-repeat" style="background-image: url('{{ asset('images/feature-title-bg.png') }}')">
                                    @if (!empty($feature['feature_icon']))
                                        <span class="flex items-center justify-center rounded-[14px] border border-solid border-blue-2000 gradient w-[52px] h-[52px]"><img src="{{ \Illuminate\Support\Facades\Storage::url($feature['feature_icon']) }}" alt="{{ $feature['feature_title'] ?? '' }}">
                                        </span>
                                    @endif
                                    <div class="flex-1 w-full">
                                        @if (!empty($feature['feature_title']))
                                            <h4 class="text-lg font-medium leading-6 text-white md:text-xl md:leading-5">
                                                {{ $feature['feature_title'] }}</h4>
                                        @endif
                                        @if (!empty($feature['feature_description']))
                                            <div class="text-white/80 font-medium text-sm leading-[18px] md:mt-2 mt-1">
                                                {!! $feature['feature_description'] !!}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <ul class="flex flex-col gap-3 items-center mt-4 md:flex-row md:mt-10">
                        <li class="w-full md:w-auto">
                            <a href="{{ $request_estimate_button_link }}" class="md:text-[19.6px] text-lg font-bold md:leading-7 leading-6 md:tracking-[-0.118px] tracking-[-0.108px] text-black rounded-full btn-gradient transition-all duration-500 ease-in-out h-[52px] md:pl-6 md:pr-[35px] shadow-24xl flex items-center justify-center gap-2.5">
                                <span class="flex justify-center items-center w-7 h-7">
                                    <x-icon-flashlight-fill-v2 class="brightness-0" />
                                </span>
                                {{ $request_estimate_button_text }}
                            </a>
                        </li>
                        <li class="w-full md:w-auto">
                            <a href="{{ $how_work_link }}" class="md:text-[19.6px] text-lg font-medium leading-7 md:tracking-[-0.118px] tracking-[-0.108px] shadow-25xl text-white rounded-full hover:bg-gray-1400 hover:border-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out border border-solid border-gray-1200 h-[52px] px-[19.6px] flex items-center justify-center">{{ $how_work_text }}</a>
                        </li>
                    </ul>
                    <div class="flex flex-col gap-4 items-start px-5 py-4 mt-4 property-group md:items-center md:flex-row 2xl:px-5 md:px-3 md:mt-10">
                        <span class="border-white/[0.32] bg-white/12 rounded-[10px] w-10 h-10 flex items-center justify-center">
                            <x-icon-user-group />
                        </span>
                        <p class="flex-1 w-full text-lg font-medium leading-7 text-white capitalize 2xl:text-xl md:text-base">
                            Join <span class="font-semibold property-number"> 2400 </span> property owners who
                            got a
                            water well estimate online!</p>
                    </div>
                </div>
                    <div class="xl:max-w-[425px] lg:max-w-[315px] max-w-full w-full">
                        <div class="rounded-[19.2px] p-[12.8px] backdrop-blur-[9.60px] contractor-box">
                            @if (!empty($featured_image))
                                <img src="{{ $featured_image }}"
                                    alt="{{ $contractor_name }}"
                                    class="w-full xl:h-[336px] lg:h-[240px] sm:h-[350px] h-[236px] object-cover object-center rounded-[12.8px]" />
                            @endif
                            <div class="text-center mt-[12.8px]">
                                <h4 class="text-white font-bold md:text-[19.2px] text-lg leading-[25.6px] md:mb-1 mb-0.5">
                                    {{ __('Licensed and insured') }}
                                </h4>
                                <p class="text-white/[0.8] font-normal md:text-[14.4px] text-sm leading-[19.2px]">
                                    {{ $contractor_name }}
                                </p>
                            </div>
                        </div>
                        <div class="md:p-6 p-4 mt-3 rounded-[18px] backdrop-blur-[9.60px] contractor-box">
                            <h3 class="text-[30px] text-left font-normal text-white leading-9 tracking-[-0.6px]">
                                {!! $quick_process_heading !!}
                            </h3>
                            @if (!empty($quick_process))
                                <ul class="mt-4">
                                    @foreach ($quick_process as $process)
                                        <li class="flex gap-2 items-center @if (!$loop->last) mb-4 @endif">
                                            <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 text-white rounded-full round-gradient">
                                                {{ $loop->iteration }}
                                            </span>
                                            @if (!empty($process['process_name']))
                                                <p class="flex-1 w-full text-white text-base font-normal tracking-[-0.32px]">
                                                    {{ $process['process_name'] }}</p>
                                            @endif
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </div>
            </div>
        </div>
    </div>
</div>
