<div class="p-3 bg-white">
    <div class="md:rounded-3xl rounded-[40px] bg-black-1800 md:py-[68px] py-4">
        <div class="max-w-[1232px] w-full  mx-auto md:px-4 px-0">
            <div class="text-center md:px-0 px-6">
                <h3 class="xl:text-5xl lg:text-4xl md:text-[40px] text-[32px] text-white font-normal lg:leading-[56px] md:leading-[48px] leading-10 md:tracking-[-0.96px] tracking-[-0.64px]">
                    {!! $heading !!}
                </h3>
                @if (!empty($description))
                    <div class="text-white font-normal md:text-lg text-base leading-6 md:tracking-[-0.27px] tracking-[-0.24px] mt-1.5">
                        {!! $description !!}
                    </div>
                @endif
            </div>
            @if ($categories->isNotEmpty())
                <div class="md:mt-[60px] mt-6">
                    <div class="md:hidden block">
                        <div class="swiper homeServicesSwiper !px-2.5">
                            <div class="swiper-wrapper">
                                @foreach ($categories as $category)
                                    <div class="swiper-slide">
                                        <a href="{{ route('member.index', ['category' => [$category->slug]]) }}" class="group explor-link min-h-[148px] border border-solid border-black-1900 shadow-[18px] bg-black-2000 hover:bg-gray-1900 hover:border-white transition-all duration-500 ease-in-out md:p-6 hover:py-[25px] p-4 flex flex-col items-start  md:gap-5 gap-3.5 rounded-[18px]">

                                            @if ($category->getFirstMediaUrl('category_logo'))
                                                <span class="flex items-center justify-center md:rounded-[14px] rounded-[8px]  border border-solid border-blue-2000 gradient w-[52px] h-[52px] group-hover:w-[54px] group-hover:h-[58px] group-hover:mx-auto transition-all duration-500 ease-in-out">
                                                    <img src="{{ $category->getFirstMediaUrl('category_logo') }}" alt="{{ $category->category_name }}" />
                                                </span>
                                            @else
                                                <span class="flex items-center justify-center md:rounded-[14px] text-white rounded-[8px]  border border-solid border-blue-2000 gradient w-[52px] h-[52px] group-hover:w-[54px] group-hover:h-[58px] group-hover:mx-auto transition-all duration-500 ease-in-out">
                                                    <x-icon-category-logo-placeholder />
                                                </span>
                                            @endif
                                            </span>
                                            <h4 class="group-hover:text-black-1200 text-white font-medium text-lg leading-6 tracking-[-0.27px] flex-2 w-full group-hover:text-center transition-all duration-500 ease-in-out">
                                                {{ $category->category_name }}
                                            </h4>
                                        </a>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="swiper-pagination456 flex items-center justify-center mt-6 !static"></div>
                    </div>
                    <ul class="md:grid hidden grid-cols-1 xl:grid-cols-4 lg:grid-cols-3 sm:grid-cols-2 gap-6">
                        @foreach ($categories as $category)
                            <li>
                                <a href="#" class="group explor-link border border-solid border-black-1900 shadow-[18px] bg-black-2000 hover:bg-gray-1900 hover:border-white transition-all duration-500 ease-in-out md:p-6 p-4 flex items-center md:gap-5 gap-3.5 rounded-[18px]">
                                    @if ($category->getFirstMediaUrl('category_logo'))
                                        <span class="flex items-center justify-center md:rounded-[14px] rounded-[8px]  border border-solid border-blue-2000 gradient md:w-[52px] w-11 md:h-[52px] h-11">
                                            <img src="{{ $category->getFirstMediaUrl('category_logo') }}" alt="{{ $category->category_name }}" />
                                        </span>
                                    @else
                                        <span class="flex items-center justify-center md:rounded-[14px] rounded-[8px]  border border-solid border-blue-2000 gradient md:w-[52px] w-11 md:h-[52px] h-11 text-white">
                                            <x-icon-category-logo-placeholder />
                                        </span>
                                    @endif
                                    <h4 class="group-hover:text-black-1200 text-white font-medium md:text-lg text-base leading-6 tracking-[-0.27px] flex-2 w-full">
                                        {{ $category->category_name }}</h4>
                                </a>
                            </li>
                        @endforeach

                    </ul>
                </div>
            @endif
        </div>
    </div>
</div>
