@extends('layouts.app')
@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries=places,marker"
        async
        defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush
@php
    use Illuminate\Support\Str;
    $heading = $page->heading ?? __('Explore the latest jobs near you');
    $description = $page->content ?? __('Explore the latest jobs near you');
    // Get featured and gallery images
    $featuredImage = $equipment->getMedia('featured_image')->first();
    $galleryImages = $equipment->getMedia('gallery');

    // Create unified collection of all images (featured first, then gallery)
    $allImages = collect();
    if ($featuredImage) {
        $allImages->push($featuredImage);
    }
    $allImages = $allImages->concat($galleryImages);
    // Determine main image and check if we have any images
    $hasImages = $allImages->isNotEmpty();
    $mainImage = $allImages->first();
    $mainImageUrl = $mainImage ? $mainImage->getUrl('large') : '';
    $thumbnailImages = $allImages->skip(1)->take(4);
    $totalImages = $allImages->count();
    $files = $equipment->getMedia('additional_resources');
    $user = $equipment->user;
@endphp
@section('content')
    <section class="pt-8">
        <div class="max-w-[1310px] w-full mx-auto md:px-4">
            <div class="flex justify-between relative flex-col lg:flex-row">
                <div class="relative px-6 md:px-0">
                    <h3 class="text-2xl font-medium leading-8 text-black-1200 max-w-3xs sm:max-w-full sm:mr-3 md:mr-0">
                        {{ $equipment->title }}
                    </h3>
                    @if ($equipment->getEquipmentCategories(1)->isNotEmpty())
                        <ul class="flex flex-wrap gap-2 items-center mt-3">
                            <li><a href="#" class="tags">{{ $equipment->getEquipmentCategories(1)->pluck('category_name')->first() }}</a></li>
                        </ul>
                    @endif
                    @if ($equipment->getEquipmentFullAddress())
                        <span class="text-mid-gray mt-3 font-medium xl:text-sm text-xs tracking-[-0.096px] flex items-center gap-2 mb-2">
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-location-outline-v2 />
                            </span>
                            {{ $equipment->getEquipmentFullAddress('short') }}
                        </span>
                    @endif
                </div>
                <!-- EQUIPMENT CONTACT  Desktop-->
                <div class="xl:max-w-[321px] lg:max-w-[200px] max-w-full w-full lg:mt-0 mt-4 mr-6">
                    <div class="md:mb-3">
                        <ul class="flex absolute top-0 right-0 gap-3 justify-center items-center md:static pr-6 md:pr-0">
                            <li>
                                <x-frontend.includes.share-modal-button :user="$user"
                                    url="{{ $equipment->permalink }}"
                                    type="equipment"
                                    class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 pr-0.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                                    <x-icon-share-icon class="w-4 h-4" />
                                    <span class="hidden md:block">{{ __('Share') }}</span>
                                </x-frontend.includes.share-modal-button>
                            </li>
                            <li>
                                <x-frontend.includes.add-favorite-button module="equipment"
                                    :modelId="$equipment->uuid"
                                    :isFavorite="$equipment->isFavorite()"
                                    class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                                    <x-icon-save-icon class="w-4 h-4" />
                                    <span class="hidden md:block">{{ __('Save') }}</span>
                                </x-frontend.includes.add-favorite-button>
                            </li>
                        </ul>
                    </div>
                    <div class="grid fixed right-0 bottom-0 left-0 z-10 grid-cols-2 gap-3 p-6 w-full bg-white border-t border-solid bottom-action md:block md:gap-0 md:bg-transparent md:w-auto md:static md:p-0 md:border-0 border-gray-1200 md:relative">
                        @if (!empty($user->profile->phone))
                            <a href="tel:{{ $user->profile->phone }}" class="mb-3 primary-btn">
                                <x-icon-phone-icon class="w-4 h-4" />
                                {{ __('Call') }}
                            </a>
                        @endif
                        @if (!empty($user->email))
                            <x-frontend.includes.contact-modal-button :user="$user" class="secondary-btn">
                                <x-icon-chat-icon-blue class="w-4 h-4" /> {{ __('Message us') }}
                            </x-frontend.includes.contact-modal-button>
                        @endif
                    </div>
                </div>
            </div>

            <!-- EQUIPMENT CONTACT  Mobile-->
            <div class="block md:hidden px-6 md:px-0">
                @if (!empty($user->profile?->phone))
                    <a href="tel:{{ $user->profile?->phone }}" class="mb-3 primary-btn">
                        <x-icon-phone-icon /> {{ __('Calls') }}
                    </a>
                @endif
                @if (!empty($user->email))
                    <x-frontend.includes.contact-modal-button :user="$user" class="secondary-btn">
                        <x-icon-chat-icon-blue class="w-4 h-4" /> {{ __('Message us') }}
                    </x-frontend.includes.contact-modal-button>
                @endif
            </div>

            @if ($hasImages)
                <!----- PROJECT GALLERY ------>
                <div class="hidden grid-cols-2 gap-2.5 mt-8 md:grid" id="equipment-gallery">
                    @if ($mainImage)
                        <div>
                            <a href="{{ $mainImage->getUrl('large') }}"
                                class="flex justify-center items-center equipment-gallery-item"
                                data-src="{{ $mainImage->getUrl('large') }}"
                                data-sub-html="{{ $equipment->title }}">
                                <img src="{{ $mainImage->getUrl('medium') }}"
                                    alt="{{ $equipment->title }}"
                                    data-src="{{ $mainImage->getUrl('medium') }}"
                                    data-sub-html="{{ $equipment->title }}"
                                    class="object-fill w-full rounded-xl"
                                    style="height: 391px;"
                                    loading="lazy" />
                            </a>
                        </div>
                    @endif

                    <div class="grid grid-cols-2 gap-2.5">
                        @for ($i = 1; $i < min(5, $totalImages); $i++)
                            @php $image = $allImages->skip($i)->first(); @endphp
                            @if ($i == 4 && $totalImages > 5)
                                <div class="relative">
                                    <a href="{{ $image->getUrl('large') }}"
                                        class="flex justify-center items-center equipment-gallery-item"
                                        data-src="{{ $image->getUrl('thumb') }}"
                                        data-sub-html="{{ $equipment->title }}">
                                        <img src="{{ $image->getUrl('thumb') }}"
                                            alt="{{ $equipment->title }}"
                                            class="object-fill w-full h-48 rounded-xl"
                                            loading="lazy" />
                                    </a>
                                    <button onclick="window.openEquipmentGallery()" class="absolute right-4 bottom-4 flex items-center justify-center text-black font-medium text-sm leading-5 tracking-[-0.096px] gap-2.5 rounded-lg bg-white/[0.9] bg-shadow-4xl h-9 max-w-[153px] w-full">
                                        <x-icon-grid-icon />
                                        {{ __('Show all photos') }}
                                    </button>
                                </div>
                            @else
                                <div class="">
                                    <a href="{{ $image->getUrl('large') }}"
                                        class="flex justify-center items-center equipment-gallery-item"
                                        data-src="{{ $image->getUrl('large') }}"
                                        data-sub-html="{{ $equipment->title }}">
                                        <img src="{{ $image->getUrl('thumb') }}"
                                            alt="{{ $equipment->title }}"
                                            class="object-fill w-full h-48 rounded-xl"
                                            loading="lazy" />
                                    </a>
                                </div>
                            @endif
                        @endfor
                        @if ($totalImages > 5)
                            <div class="hidden">
                                @foreach ($allImages->skip(5) as $image)
                                    <a href="{{ $image->getUrl('large') }}"
                                        class="equipment-gallery-item"
                                        data-src="{{ $image->getUrl('large') }}"
                                        data-sub-html="{{ $equipment->title }}">
                                        <img src="{{ $image->getUrl('thumb') }}"
                                            alt="{{ $equipment->title }}"
                                            class="hidden"
                                            loading="lazy" />
                                    </a>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
                <div class="block mt-8 md:hidden">
                    <div class="swiper gallerySwiper">
                        <div class="swiper-wrapper">
                            @foreach ($allImages as $image)
                                <div class="swiper-slide">
                                    <a href="{{ $image->getUrl('medium') }}"
                                        class="flex justify-center items-center"
                                        data-src="{{ $image->getUrl('medium') }}"
                                        data-sub-html="{{ $equipment->title }}">
                                        <img src="{{ $image->getUrl('medium') }}"
                                            alt="{{ $equipment->title }}"
                                            class="w-full h-[280px] object-center object-cover"
                                            loading="lazy" />
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        <div class="swiper-pagination text-xs font-medium leading-4 text-black h-6 rounded-lg bg-white/[0.24] border border-solid border-white/[0.16] inline-flex items-center justify-center px-4 bottom-3 right-3 !left-auto !w-auto">
                        </div>
                        <div class="swiper-button-next bg-white !w-8 !h-8 rounded-full flex items-center justify-center after:hidden">
                            <x-icon-right-arrow-v2 />
                        </div>
                        <div class="swiper-button-prev bg-white !w-8 !h-8 rounded-full flex items-center justify-center after:hidden">
                            <x-icon-left-arrow-v2 />
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
    <!----- GALLERY  SEC ------>
    <section class="pt-12 pb-8 sm:pt-8 md:pb-20">
        <div class="max-w-[1310px] w-full mx-auto md:px-4 px-6">
            <div class="flex flex-col gap-0 items-start lg:flex-row lg:gap-8">
                <div class="xl:w-[calc(100%_-_447px)] lg:w-[calc(100%_-_320px)] w-full">
                    <div>
                        @if (!empty($equipment->specification))
                            <div class="pb-12 border-b border-solid border-gray-1200">
                                <h6>{{ __('Specifications') }}</h6>
                                <div class="grid grid-cols-1 gap-4 mt-5 2xl:grid-cols-4 md:grid-cols-3 sm:grid-cols-2">
                                    @foreach ($equipment->specification as $specification)
                                        <div class="p-4 rounded-2xl border border-solid border-gray-1400 bg-gray-1400">
                                            @if (!empty($specification['specification_name']))
                                                <p class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.096px]">
                                                    {{ $specification['specification_name'] }}</p>
                                            @endif
                                            @if (!empty($specification['specification_value']))
                                                <h4 class="text-black-1200 font-medium text-base leading-5 tracking-[-0.176px] mt-1.5">
                                                    {{ $specification['specification_value'] }}</h4>
                                            @endif
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        @if (!empty($equipment->description) || !empty($equipment->use_case) || !empty($equipment->constraint))
                            <div class="py-12 border-b border-solid border-gray-1200">
                                <h6>{{ __('Description & Usage') }}</h6>
                                @if ($equipment->description)
                                    <div x-data="{
                                        expanded: false,
                                        showButton: false,
                                        init() {
                                            this.$nextTick(() => {
                                                this.showButton = this.$refs.content.scrollHeight > this.$refs.content.clientHeight;
                                            });
                                        }
                                    }">
                                        <div x-ref="content"
                                            :style="expanded ? 'max-height: ' + $refs.content.scrollHeight + 'px' : 'max-height: 4.5rem'"
                                            class="max-w-[800px] w-full lg:text-base md:text-sm text-base font-normal leading-6 text-mid-gray mt-3 overflow-hidden transition-all duration-500 ease-in-out prose article-content">
                                            {!! tiptap_converter()->asHTML($equipment->description) !!}
                                        </div>
                                        <button x-show="showButton"
                                            @click="expanded = !expanded"
                                            class="cursor-pointer mt-5 readmore-btn text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] inline-flex items-center gap-1 transition-all duration-300 hover:opacity-80">
                                            <span x-text="expanded ? '{{ __('Read less') }}' : '{{ __('Read more') }}'" class="transition-all duration-300"></span>
                                            <div :class="expanded ? 'rotate-180' : ''" class="transition-transform duration-300">
                                                <x-icon-down-arrow2 />
                                            </div>
                                        </button>
                                    </div>
                                @endif
                                @if ($equipment->use_case || $equipment->constraint)
                                    <div class="grid grid-rows-1 gap-4 mt-5 md:grid-rows-2">
                                        @if ($equipment->use_case)
                                            <div class="bg-green-1000/[0.5] rounded-2xl p-4">
                                                <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                    {{ __('Use Cases') }}
                                                </h4>
                                                <div class="article-content">
                                                    {!! $equipment->use_case !!}
                                                </div>
                                            </div>
                                        @endif
                                        @if ($equipment->constraint)
                                            <div class="bg-pink-1000/[0.5] rounded-2xl p-4">
                                                <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                    {{ __('Use Constraints') }}
                                                </h4>
                                                <div class="article-content">
                                                    {!! $equipment->constraint !!}
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        @endif
                        @if ($files->isNotEmpty())
                            <div class="py-12 border-b border-solid border-gray-1200">
                                <h6>{{ __('Additional Resources') }}</h6>
                                <div class="grid grid-cols-1 gap-4 mt-5 lg:grid-cols-2">
                                    @foreach ($files as $file)
                                        <div class="flex gap-1.5 items-center p-4 rounded-2xl bg-gray-1400">
                                            <span class="flex justify-center items-center w-10 h-10">
                                                <x-icon-file-download />
                                            </span>
                                            <div class="flex flex-1 justify-between items-center w-full">
                                                <div class="flex-1 w-full">
                                                    <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">{{ Str::upper($file->extension) }}</span>
                                                    <p class="flex items-center font-medium text-sm tracking-[-0.096px] leading-6 text-black-1200">
                                                        {{ str()->headline($file->name) }}</p>
                                                </div>
                                                <a href="{{ $file->getUrl() }}" class="flex justify-center items-center w-9 h-9">
                                                    <x-icon-download-icon />
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach

                                </div>

                            </div>
                        @endif
                        <div class="block py-12 border-b border-solid border-gray-1200 lg:hidden">
                            <div class="w-full">
                                <x-frontend.sidebar.classified-author-sidebar :user="$equipment->user" :reviewsStats="$reviewsStats" />
                            </div>
                        </div>
                        <x-frontend.member.profile.partials.profile-social-media :user="$equipment->user" />
                    </div>
                </div>
                <div class="xl:max-w-[447px] max-w-[320px] w-full sticky top-5 lg:block hidden">
                    <x-frontend.sidebar.classified-author-sidebar :user="$equipment->user" :reviewsStats="$reviewsStats" />
                </div>
            </div>
        </div>
    </section>
    <div class="grid fixed right-0 bottom-0 left-0 z-50 grid-cols-2 gap-3 p-6 w-full bg-white border-t border-solid bottom-action md:hidden md:p-0 border-gray-1200">
        <a href="{{ route('member.show', ['slug' => $equipment->author->slug]) }}" class="secondary-btn">
            <x-icon-right-top-arrow />
            {{ __('View Profile') }}
        </a>
        <a href="tel:{{ $equipment->author->phone }}" class="mb-3 primary-btn">
            <x-icon-phone-icon />
            {{ __('Call') }}
        </a>
    </div>
@endsection
