@extends('layouts.app')
@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@php
    $heading = $page->heading ?? __('Explore the latest jobs near you');
    $description = $page->content ?? __('Explore the latest jobs near you');
    $breadcrumbs = ['name' => 'job-list'];
    $libraries = 'places,marker';
@endphp
@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries={{ $libraries }}"
        async
        defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush
@section('content')
    <section Class="pt-8 pb-0 lg:py-8">
        <livewire:frontend.job.job-list :page="$page"
            :breadcrumbs="$breadcrumbs"
            />
    </section>
@endsection
