@extends('layouts.app')
@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries=places,marker"
        async
        defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush
@php
    $heading = $page->heading ?? __('Explore the latest jobs near you');
    $description = $page->content ?? __('Explore the latest jobs near you');
    $breadcrumbs = ['name' => 'job-list'];
    $author = $job->user;
    // dump($job->permalink);
    $url = $job->permalink;

@endphp
@section('content')
    <section class="pt-8">
        <div class="max-w-[1310px] w-full mx-auto md:px-4">
            <div class="flex relative flex-col justify-between items-start px-6 md:flex-row md:items-center md:px-0">
                <ul class="md:hidden flex items-center gap-3 absolute right-6 top-[3px] z-50">
                    <li>
                        <x-frontend.includes.add-favorite-button module="job"
                            :modelId="$job->uuid"
                            :isFavorite="$job->isFavorite()"
                            class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid transition-all duration-500 ease-in-out group shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 border-gray-1200">
                            <x-icon-heart-circle-outline />
                        </x-frontend.includes.add-favorite-button>
                    </li>
                    <li>

                        <x-frontend.includes.share-modal-button :user="$author"
                            url="{{ $url }}"
                            type="job"
                            class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-9 h-9 md:h-10 md:px-3.5 pr-0.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                            <x-icon-share-icon />
                            <span class="hidden md:block"> {{ __('Share') }} </span>
                        </x-frontend.includes.share-modal-button>
                    </li>
                </ul>
                <div class="relative w-full md:w-auto">
                    <div class="flex gap-3 items-center mb-3">
                        <span class="p-1.5 w-10 h-10 rounded-2xl border border-solid border-gray-1200 md:w-12 md:h-12">
                            @if ($job->user->getMedia('logo')->count() > 0)
                                {{-- <x-frontend.member.profile.partials.profile-avatar :user="$author" /> --}}
                                <img src="{{ $job->user->getFirstMediaUrl('logo', 'small') }}" alt="{{ $job->user->name }}" />
                            @else
                                <img src="{{ $job->user->getFirstMediaUrl('avatar', 'small') }}" alt="{{ $job->user->name }}"  />
                            @endif
                        </span>
                        <h4 class="flex-1 w-full text-base font-medium leading-7 md:text-xl text-black-1200">
                            {{ $author->memberName() }}
                        </h4>
                    </div>
                    <h4 class="flex flex-col-reverse gap-3 items-start text-2xl font-medium leading-7 xl:text-2xl md:text-base text-black-1200 md:flex-row md:items-center">
                        {{ $job->job_title }}
                        @if ($job->isNew())
                            <span class="status-Badge">
                                {{ __('Newly Listed') }}
                            </span>
                        @endif
                    </h4>
                    @if ($job->jobTypeName() || $job->saleryRange() || $job->jobCarerLevel() || $job->jobIndustry() || $job->jobRole())
                        <ul class="flex flex-wrap gap-2 items-center mt-3">
                            @if ($job->jobTypeName())
                                <li>
                                    <a href="#" class="tags">
                                        {{ $job->jobTypeName() }}
                                    </a>
                                </li>
                            @endif
                            @if ($job->workMode())
                                <li>
                                    <a href="#" class="tags">
                                        {{ $job->workMode() }}
                                    </a>
                                </li>
                            @endif
                            @if ($job->saleryRange())
                                <li>
                                    <a href="#" class="tags">
                                        {{ $job->saleryRange() }}
                                    </a>
                                </li>
                            @endif
                            @if ($job->jobCarerLevel())
                                <li>
                                    <a href="#" class="tags">
                                        {{ $job->jobCarerLevel() }}
                                    </a>
                                </li>
                            @endif
                            @if ($job->jobIndustry())
                                <li>
                                    <a href="#" class="tags">
                                        {{ $job->jobIndustry() }}
                                    </a>
                                </li>
                            @endif
                        </ul>
                    @endif
                    @if ($job->address() || $job->postedDate() || $job->deadlineDate())
                        <ul class="flex flex-wrap gap-1.5 items-center mt-3 sm:gap-2">
                            @if ($job->address())
                                <li class="text-mid-gray font-medium xl:text-sm sm:text-xs text-sm tracking-[-0.096px] flex items-center sm:gap-2 gap-1.5">
                                    <span class="flex justify-center items-center w-5 h-5">
                                        <x-icon-location-outline-v2 />
                                    </span>
                                    {{ $job->address('short') }}
                                </li>
                            @endif
                            @if ($job->postedDate())
                                <li class="text-mid-gray font-medium xl:text-sm sm:text-xs text-sm tracking-[-0.096px] flex items-center sm:gap-2 gap-1.5 md:border-l border-solid border-gray-1200 md:px-2">
                                    <span class="flex justify-center items-center w-5 h-5">
                                        <x-icon-calendar-icon3 />
                                    </span>{{ __('Posted:') }} {{ $job->postedDate() }}
                                </li>
                            @endif
                            @if ($job->deadlineDate())
                                <li class="text-mid-gray font-medium xl:text-sm sm:text-xs text-sm tracking-[-0.096px] flex items-center sm:gap-2 gap-1.5 md:border-l border-solid border-gray-1200 md:px-2">
                                    <span class="flex justify-center items-center w-5 h-5">
                                        <x-icon-clock-icon />
                                    </span>{{ __('Deadline:') }} {{ $job->deadlineDate() }}
                                </li>
                            @endif
                        </ul>
                    @endif
                </div>

                <div class="lg:max-w-[321px] md:max-w-[200px] max-w-full w-full lg:mt-0 mt-6">
                    <div class="md:mb-3">
                        <ul class="hidden gap-3 justify-center items-center md:flex">
                            <li>
                                <x-frontend.includes.share-modal-button :user="$author"
                                    url="{{ $job->permalink }}"
                                    type="job"
                                    class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 pr-0.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                                    <x-icon-share-icon />
                                    <span class="hidden md:block"> {{ __('Share') }} </span>
                                </x-frontend.includes.share-modal-button>
                            </li>
                            <li>
                                <x-frontend.includes.add-favorite-button module="job"
                                    :modelId="$job->uuid"
                                    :isFavorite="$job->isFavorite()"
                                    class="group md:border-0 border border-solid border-gray-1200  md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                                    <x-icon-save-icon class="w-4 h-4" />
                                    <span class="hidden md:block"> {{ __('Save') }} </span>
                                </x-frontend.includes.add-favorite-button>
                            </li>
                        </ul>
                    </div>
                    <div class="block">
                        <a href="{{ route('job.apply', ['slug' => $job->slug]) }}" class="mb-3 primary-btn">
                            <x-icon-right-top-arrow />
                            {{ __('Apply Now') }}
                        </a>
                        <a href="#" class="secondary-btn text-[#335CFF]">
                            <x-icon-copy-link />
                            {{ __('Copy Link') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!----- GALLERY  SEC ------>
    <section class="pt-12 pb-8 sm:pt-8 md:pb-20">
        <div class="max-w-[1310px] w-full mx-auto md:px-4 px-6">
            <div class="flex flex-col gap-0 items-start lg:flex-row lg:gap-8">
                <div class="xl:w-[calc(100%_-_447px)] lg:w-[calc(100%_-_320px)] w-full">
                    <div>
                        @if (!empty($job->job_description))
                            <div class="pt-0 pb-6 md:py-6">
                                <h6>{{ __('Job Description') }}</h6>
                                <div x-data="{ expanded: false }" class="">
                                    <!-- Preview: HTML version with line limit -->
                                    <div x-show="!expanded" class="max-w-[800px] w-full lg:text-base md:text-sm text-base font-normal leading-6 text-mid-gray mt-3 line-clamp-3 article-content prose">
                                        {!! tiptap_converter()->asHTML($job->job_description) !!}
                                    </div>
                                    <!-- Full: HTML version -->
                                    <div x-show="expanded" class="max-w-[800px] w-full lg:text-base md:text-sm text-base font-normal leading-6 text-mid-gray mt-3 article-content prose">
                                        {!! tiptap_converter()->asHTML($job->job_description) !!}
                                    </div>
                                    @if (strlen($job->job_description) > 200)
                                        <a href="javascript:void(0)"
                                            @click="expanded = !expanded"
                                            class="mt-5 readmore-btn">
                                            <span x-text="expanded ? 'Read less' : 'Read more'"></span>
                                            <svg :class="{ 'rotate-180': expanded }"
                                                class="transition-transform duration-300"
                                                width="11"
                                                height="7"
                                                viewBox="0 0 11 7"
                                                fill="currentColor"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M5.49999 4.54697L9.21249 0.834473L10.273 1.89497L5.49999 6.66797L0.72699 1.89497L1.78749 0.834473L5.49999 4.54697Z" fill="currentColor" />
                                            </svg>
                                        </a>
                                    @endif
                                </div>
                            </div>
                        @endif
                        @if (!empty($job->key_responsibilities))
                            <div class="py-6">
                                <h6>{{ __('Key Responsibilites') }}</h6>
                                <div class="mt-3 article-content">
                                    {!! $job->key_responsibilities !!}
                                </div>
                            </div>
                        @endif
                        @if (!empty($job->required_qualifications))
                            <div class="py-6">
                                <h6>{{ __('Required Skills & Qualifications') }}</h6>
                                <div class="mt-3 article-content">
                                    {!! $job->required_qualifications !!}
                                </div>
                            </div>
                        @endif
                        @if (!empty($job->nice_to_have_skills))
                            <div class="py-6">
                                <h6>{{ __('Nice to Have Skills') }}</h6>
                                <div class="mt-3 article-content">
                                    {!! $job->nice_to_have_skills !!}
                                </div>
                            </div>
                        @endif
                        @if (!empty($job->bonus_and_benefits))
                            <div class="py-6 border-b border-solid border-gray-1200">
                                <h6>{{ __('Benefits') }}</h6>
                                <div class="mt-3 article-content">
                                    {!! $job->bonus_and_benefits !!}
                                </div>
                            </div>
                        @endif

                        @if ($job->mapIframeUrl())
                            <div class="py-12 border-b border-solid border-gray-1200">
                                <h6>{{ __('Job Location') }}</h6>
                                <div class="mt-3 sm:mt-5">
                                    <p class="mb-5 text-base font-normal leading-6 text-mid-gray">
                                        {{ $job->address() }}
                                    </p>
                                    <iframe width="100%"
                                        height="350"
                                        frameborder="0"
                                        style="border:0"
                                        referrerpolicy="no-referrer-when-downgrade"
                                        src="{{ $job->mapIframeUrl() }}"
                                        allowfullscreen>
                                    </iframe>
                                </div>
                            </div>
                        @endif
                        <div class="block py-12 border-b border-solid border-gray-1200 lg:hidden">
                            <x-frontend.sidebar.job-sidebar :user="$author"
                                :reviewsStats="$reviewsStats"
                                :job="$job" />
                        </div>

                        <x-frontend.job.job-detail.related-jobs :job="$job" />

                        <div class="pt-12">
                            <div class="mb-12">
                                <x-frontend.sidebar.widgets.ads-alert type="Job" />
                            </div>
                            <div class="mb-12">
                                <x-frontend.member.profile.partials.profile-social-media :user="$author" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="xl:max-w-[447px] max-w-[320px] w-full sticky top-5 lg:block hidden">
                    <x-frontend.sidebar.job-sidebar :user="$author"
                                :reviewsStats="$reviewsStats"
                                :job="$job" />
                    {{-- <x-frontend.sidebar.job-author-sidebar :user="$author" :reviewsStats="$reviewsStats" />
                    <div class="mt-6">
                        <x-frontend.sidebar.widgets.job-apply-alert />
                    </div> --}}
                </div>
            </div>
        </div>
    </section>

    <div class="grid fixed right-0 bottom-0 left-0 z-50 grid-cols-2 gap-3 p-6 w-full bg-white border-t border-solid bottom-action md:hidden md:p-0 border-gray-1200">
        <a href="{{ route('member.show', ['slug' => $author->slug]) }}" class="secondary-btn">
            <x-icon-right-top-arrow />
            {{ __('View Profile') }}
        </a>
        <a href="tel:{{ $author->phone }}" class="mb-3 primary-btn">
            <x-icon-phone-icon />
            {{ __('Call') }}
        </a>
    </div>
@endsection
