<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }} - Coming Soon</title>

    <!-- SEO -->
    @stack('seo')

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Vite Assets -->
    @vite(['resources/css/app.css', 'resources/js/app.js', 'themes/ep/esp_theme/resources/css/esp_theme.css'])

    <!-- Additional CSS to ensure styling for specific gradients and effects -->
    <style>
        /* Only include styles that might not be in the Tailwind compilation */
        .bg-white\/10 {
            background-color: rgb(255 255 255 / 0.1);
        }

        .backdrop-blur-sm {
            backdrop-filter: blur(4px);
        }

        .border-white\/20 {
            border-color: rgb(255 255 255 / 0.2);
        }
    </style>

    <!-- Livewire Styles -->
    @livewireStyles
</head>

<body class="antialiased font-Poppins">
    <main>
        @yield('content')
    </main>

    <!-- Livewire Scripts -->
    @livewireScripts
</body>

</html>
