@unless ($breadcrumbs->isEmpty())
    <nav class="flex">
        <ol class="inline-flex gap-2 items-center sm:gap-3">
            @foreach ($breadcrumbs as $breadcrumb)
                @if ($breadcrumb->url && !$loop->last)
                    <li class="inline-flex items-center">
                        <a href="{{ $breadcrumb->url }}" class="inline-flex items-center text-sm font-medium tracking-[-0.096px] text-[#415B78]">
                            <span class="w-8 break-words line-clamp-1 md:w-auto">{{ $breadcrumb->title }}</span>
                        </a>
                    </li>
                @elseif ($loop->last)
                    <li>
                        <span class="inline-flex items-center text-sm font-medium tracking-[-0.096px] text-[#2D2E2E]">{{ $breadcrumb->title }}</span>
                    </li>
                @else
                    <li class="inline-flex items-center">
                        <a href="{{ $breadcrumb->url }}" class="inline-flex items-center text-sm font-medium tracking-[-0.096px] text-[#415B78]">
                            <span class="w-8 break-words line-clamp-1 md:w-auto">{{ $breadcrumb->title }}</span>
                        </a>
                    </li>
                @endif

                @unless ($loop->last)
                    <li class="flex items-center sm:mt-[3px]">
                        <svg class="mx-1 w-1.5 h-2 rtl:rotate-180 sm:h-2.5 text-gray-1600" aria-hidden="true"
                            xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="m1 9 4-4-4-4"></path>
                        </svg>
                    </li>
                @endif
            @endforeach
        </ol>
    </nav>
@endunless
