<!---- FOOTER ---->
<a href="#top" class="lg:flex hidden items-center justify-center rounded-full 2xl:w-[50px] 2xl:h-[50px] w-8 h-8 hover:bg-primary-blue transition-all duration-500 ease-in-out bg-red-1300 fixed 2xl:bottom-8 bottom-4 z-50 2xl:right-8 right-4">
    <x-icon-top-arrow />
</a>
<!---- FOOTER ---->
<footer class="p-3">
    <div class="py-6 rounded-3xl md:py-16 bg-black-1800">
        <div class="max-w-[1232px] w-full  mx-auto md:px-4 px-3">
            <div class="grid grid-cols-1 gap-6 mb-0 lg:grid-cols-2 lg:mb-0 md:mb-5">
                <div class="">
                    <div class="">
                        @if (!empty($footerLogo))
                            <a href="{{ route('home') }}" class="flex items-center">
                                <img src="{{ $footerLogo }}"
                                    alt="ESP Marketplace Footer Logo"
                                    class="md:h-auto h-10" />
                            </a>
                        @else
                            <a href="{{ route('home') }}" class="flex items-center">
                                {!! Theme::image('img/light_logo.png', 'ESP Marketplace Footer Logo') !!}
                            </a>
                        @endif
                        @if (!empty($about))
                            <p class="text-white max-w-[401px] w-full text-lg font-normal leading-6 tracking-[-0.27px] md:mt-10 mt-4">
                                {{ $about }}
                            </p>
                        @endif
                    </div>
                    <div class="">
                        @if (!empty($social_links))
                            <ul class="flex gap-3 items-center mt-4 mb-6 md:mt-6 md:mb-10">
                                @if (!empty($social_links['facebook']))
                                    <li><a href="{{ $social_links['facebook'] }}" class="flex justify-center items-center w-10 h-10 bg-white rounded-full border border-solid border-gray-1200 shadow-3xl"><x-icon-facebook /></a></li>
                                @endif
                                @if (!empty($social_links['twitter']))
                                    <li><a href="{{ $social_links['twitter'] }}" class="flex justify-center items-center w-10 h-10 bg-white rounded-full border border-solid border-gray-1200 shadow-3xl"><x-icon-twitter-x /></a></li>
                                @endif
                                @if (!empty($social_links['linkedin']))
                                    <li><a href="{{ $social_links['linkedin'] }}" class="flex justify-center items-center w-10 h-10 bg-white rounded-full border border-solid border-gray-1200 shadow-3xl"><x-icon-linkedin /></a></li>
                                @endif
                                @if (!empty($social_links['instagram']))
                                    <li><a href="{{ $social_links['instagram'] }}" class="flex justify-center items-center w-10 h-10 bg-white rounded-full border border-solid border-gray-1200 shadow-3xl">
                                        <x-icon-instagram />
                                    </a></li>
                                @endif
                            </ul>
                        @endif
                        @if (!empty($copyright))
                            <p class="text-xs font-normal leading-4 text-white block">
                                {{ $copyright }}
                            </p>
                        @endif
                    </div>
                </div>
                <div class="flex flex-wrap justify-between lg:max-w-[509px] w-full ml-auto items-start sm:flex-nowrap">
                    @if (!empty($menu_1))
                        <div class="w-1/2 md:w-auto">
                            <h4 class="text-base font-semibold leading-6 text-white">Pages</h4>
                            <x-filament-menu-builder::menu slug="{{ $menu_1 }}" view="layouts.includes.footer.footer-nav" />
                        </div>
                    @endif
                    @if (!empty($menu_2))
                        <div class="w-1/2 md:w-auto">
                            <h4 class="text-base font-semibold leading-6 text-white">Legal</h4>
                            <x-filament-menu-builder::menu slug="{{ $menu_2 }}" view="layouts.includes.footer.footer-nav" />
                        </div>
                    @endif
                    @if (!empty($subscription))
                        <div class="md:max-w-[165px] max-w-full w-full md:mt-0 mt-6">
                            @if (!empty($subscription['heading']))
                                <h4 class="text-base font-semibold leading-6 text-white">
                                    {{ $subscription['heading'] }}
                                </h4>
                            @endif
                            </h4>
                            @if (!empty($subscription['sub_heading']))
                                <p class="mt-4 mb-5 text-white font-normal text-sm leading-5 tracking-[-0.084px]">
                                    {{ $subscription['sub_heading'] }}
                                </p>
                            @endif
                            <form>
                                <input type="text"
                                    placeholder="Enter email here"
                                    class="text-gray-1500 placeholder:text-gray-1500 font-normal text-sm leading-5 tracking-[-0.084px] bg-white border border-solid border-gray-1200 rounded-full shadow-3xl pl-3 h-10 w-full"
                                    placeholder="Enter email here" />
                                <a href="#" class="text-sm font-medium leading-5 tracking-[-0.084px] text-white flex items-center justify-center bg-black-1200 rounded-full h-10 w-full mt-3">Subscribe</a>
                            </form>
                            @if (!empty($subscription['helper_text']))
                                <p class="mt-4 text-xs md:text-left text-center font-normal leading-4 text-white xl:text-sm">
                                    {{ $subscription['helper_text'] }}
                                </p>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- Back to top button -->
<a href="#top" class="lg:flex hidden items-center justify-center rounded-full 2xl:w-[50px] 2xl:h-[50px] w-8 h-8 hover:bg-primary-blue transition-all duration-500 ease-in-out bg-red-1300 fixed 2xl:bottom-8 bottom-4 z-50 2xl:right-8 right-4">
    <x-icon-top-arrow />
</a>

<!-- Share Modal -->
<x-frontend.includes.share-modal />
