<header class="border-b border-solid border-gray-1200 lg:py-[21px] md:py-3.5 py-3">
    <div class="max-w-[1310px] w-full mx-auto px-4">
        <div class="flex flex-wrap justify-between items-center">
            <div class="flex gap-3 items-center">
                <button data-collapse-toggle="navbar-cta"
                    type="button"
                    class="inline-flex justify-center items-center w-10 h-10 rounded-full border border-solid border-gray-1200 md:hidden menu-btn focus:outline-none focus:ring-0 focus:ring-transparent"
                    aria-controls="navbar-cta"
                    aria-expanded="false">
                    <span class="sr-only">{{ __('Open main menu') }}</span>
                    <x-icon-menu-icon class="menu-icon header-mobile-logo" />
                </button>
                <a href="{{ route('home') }}" class="flex items-center space-x-3 rtl:space-x-reverse">
                    <img src="{{ get_ligth_logo() }}"
                        alt="Site Logo"
                        class="h-[45px] header-main-logo" />
                </a>
            </div>
            <div class="flex space-x-3 md:order-2 md:space-x-0 rtl:space-x-reverse">
                <ul class="flex gap-2 items-center">
                    @auth
                        <li>
                            <a href="{{ route('dashboard') }}" class="lg:text-sm md:text-xs text-sm font-medium leading-5 tracking-[-0.096px] text-white flex items-center justify-center bg-black-1200 rounded-full lg:h-10 md:h-8 h-10 w-[105px]">{{ __('Dashboard') }}</a>
                        </li>
                    @else
                        <li class="hidden md:block">
                            <x-frontend.includes.login-modal-button class="lg:text-sm text-xs font-medium leading-5 tracking-[-0.096px] text-mid-gray flex items-center justify-center border border-solid border-gray-1200 rounded-full lg:h-10 h-8 w-[65px] shadow-3xl">
                                {{ __('Login') }}
                            </x-frontend.includes.login-modal-button>
                        </li>
                        <li>
                            <x-frontend.includes.register-modal-button class="lg:text-sm md:text-xs text-sm font-medium leading-5 tracking-[-0.096px] text-white flex items-center justify-center bg-black-1200 rounded-full lg:h-10 md:h-8 h-10 w-[105px]">
                                {{ __('Join') }}
                            </x-frontend.includes.register-modal-button>
                        </li>
                    @endauth
                </ul>
            </div>
            <div class="hidden justify-between items-center w-full md:flex md:w-auto md:order-1" id="navbar-cta">
                <x-filament-menu-builder::menu slug="header-nav" view="layouts.includes.header.header-nav" />
            </div>
        </div>
    </div>
</header>
