@php
if (! isset($scrollTo)) {
    $scrollTo = 'body';
}

$scrollIntoViewJsSnippet = ($scrollTo !== false)
    ? <<<JS
       (\$el.closest('{$scrollTo}') || document.querySelector('{$scrollTo}')).scrollIntoView()
    JS
    : '';
@endphp

@if ($paginator->hasPages())
    <div class="flex items-center justify-between">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <span class="flex items-center gap-3 text-sm font-medium cursor-not-allowed text-dark-blue/50 font-Inter">
                <img src="{{ theme_asset('img/left-long-arrow.svg') }}" alt="" class="h-3 opacity-50 sm:h-auto" />
                Previous
            </span>
        @else
            <button wire:click="previousPage" wire:loading.attr="disabled" class="flex items-center gap-3 text-sm font-medium text-dark-blue font-Inter">
                <img src="{{ theme_asset('img/left-long-arrow.svg') }}" alt="" class="h-3 sm:h-auto" />
                Previous
            </button>
        @endif

        {{-- Pagination Elements --}}
        <ul class="flex items-center sm:gap-px">
            @foreach ($elements as $element)
                {{-- "Three Dots" Separator --}}
                @if (is_string($element))
                    <li class="text-dark-blue font-medium font-Inter text-sm flex items-center justify-center w-10 h-10 rounded-[8px]">
                        {{ $element }}
                    </li>
                @endif

                {{-- Array Of Links --}}
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        <li>
                            <button wire:click="gotoPage({{ $page }})" 
                                    class="{{ $page == $paginator->currentPage() ? 'text-light-blue bg-light-blue/[0.1]' : 'text-dark-blue hover:text-light-blue hover:bg-light-blue/[0.1]' }} font-medium font-Inter text-sm flex items-center justify-center w-10 h-10 rounded-[8px]">
                                {{ $page }}
                            </button>
                        </li>
                    @endforeach
                @endif
            @endforeach
        </ul>

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <button wire:click="nextPage" wire:loading.attr="disabled" class="flex items-center gap-3 text-sm font-medium text-dark-blue font-Inter">
                Next
                <img src="{{ theme_asset('img/right-long-arrow.svg') }}" alt="" class="h-3 sm:h-auto" />
            </button>
        @else
            <span class="flex items-center gap-3 text-sm font-medium cursor-not-allowed text-dark-blue/50 font-Inter">
                Next
                <img src="{{ theme_asset('img/right-long-arrow.svg') }}" alt="" class="h-3 opacity-50 sm:h-auto" />
            </span>
        @endif
    </div>
@endif
