@extends('layouts.app')

@section('content')
    <div class="relative z-10 md:p-3 md:-mt-px">
        <div class="py-12 bg-gray-1400 md:rounded-3xl md:py-20">
            <div class="max-w-[1288px] w-full  mx-auto md:px-4 px-2.5">
                <div class="text-center md:mb-[64px] mb-9 md:px-0 px-3.5">
                    <span class="flex justify-center items-center">
                        <x-icon-success-icon2 class="rounded-full shadow-20xl" />
                    </span>
                    <h3 class="xl:text-5xl lg:text-4xl md:text-[40px] text-5xl text-black-1200 mt-4 font-normal lg:leading-[56px] md:leading-[48px] leading-[56px] md:tracking-[-0.32px] tracking-[-0.96px]">
                        {{ __('Request Sent Successfully') }}
                    </h3>
                    <div class="text-mid-gray font-medium text-lg leading-6 md:tracking-[-0.24px] tracking-[-0.27px] mt-4 max-w-[602px] w-full mx-auto">
                        {{ __('Thank you for your water well drilling estimate request. Our team is reviewing your project details and will be in touch shortly.') }}
                    </div>
                </div>
                <div class="bg-white rounded-[22px] border-[12px] border-solid border-blue-1900/[0.5] md:p-8 p-6 shadow-19xl max-w-[732px] w-full mx-auto">
                    <h5 class="text-2xl font-medium leading-8 text-black-1200">{{ __('Request Summary') }}</h5>
                    <div class="grid grid-cols-1 gap-5 my-8 md:grid-cols-2">
                        @if ($lead->leadAddress()->exists())
                            <div class="border border-solid border-gray-1200 text-center rounded-[18px] bg-white p-6">
                                <span class="flex items-center justify-center md:rounded-[14px] rounded-[8px] mx-auto border border-solid border-blue-2000 shadow-16xl gradient md:w-[52px] w-11 md:h-[52px] h-11 text-white">
                                    <x-icon-location-fill-v2 />
                                </span>
                                <h5 class="text-black-1200 mt-3 mb-1.5 font-medium text-base leading-6 tracking-[-0.176px]">
                                    {{ __('Property Location') }}
                                </h5>

                                <p class="text-mid-gray max-w-[240px] w-full mx-auto font-normal text-base leading-6">
                                    {{ $lead->leadAddress->first()->address_line_1 }}
                                </p>
                            </div>
                        @endif
                        @if (!empty($lead->phone))
                            <div class="border border-solid border-gray-1200 text-center rounded-[18px] bg-white p-6">
                                <span class="flex items-center justify-center md:rounded-[14px] rounded-[8px] mx-auto border border-solid border-blue-2000 shadow-16xl gradient md:w-[52px] w-11 md:h-[52px] h-11 text-white">
                                    <x-icon-number-icon />
                                </span>
                                <h5 class="text-black-1200 mt-3 mb-1.5 font-medium text-base leading-6 tracking-[-0.176px]">
                                    {{ __('Phone Number') }}
                                </h5>
                                <p class="text-mid-gray max-w-[240px] w-full mx-auto font-normal text-base leading-6">
                                    {{ $lead->phone }}</p>
                            </div>
                        @endif
                        @if (!empty($lead->email))
                            <div class="border border-solid border-gray-1200 text-center rounded-[18px] bg-white p-6">
                                <span class="flex items-center justify-center md:rounded-[14px] rounded-[8px] mx-auto border border-solid border-blue-2000 shadow-16xl gradient md:w-[52px] w-11 md:h-[52px] h-11 text-white">
                                    <x-icon-mail-icon />
                                </span>
                                <h5 class="text-black-1200 mt-3 mb-1.5 font-medium text-base leading-6 tracking-[-0.176px]">
                                    {{ __('Email') }}
                                </h5>
                                <p class="text-mid-gray max-w-[240px] w-full mx-auto font-normal text-base leading-6">
                                    {{ $lead->email }}</p>
                            </div>
                        @endif
                        <div class="border border-solid border-gray-1200 text-center rounded-[18px] bg-white p-6">
                            <span class="flex items-center justify-center md:rounded-[14px] rounded-[8px] mx-auto border border-solid border-blue-2000 shadow-16xl gradient md:w-[52px] w-11 md:h-[52px] h-11">
                                <x-icon-property-icon />
                            </span>
                            <h5 class="text-black-1200 mt-3 mb-1.5 font-medium text-base leading-6 tracking-[-0.176px]">
                                {{ __('Expected Response') }}
                            </h5>
                            <p class="text-mid-gray max-w-[240px] w-full mx-auto font-normal text-base leading-6">
                                {{ __('Within 24-48 hours') }}
                            </p>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 gap-5 my-8 md:grid-cols-2">
                        <div class="p-4 rounded-2xl bg-gray-1400">
                            <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">{{ __('Water Well Details') }}
                            </h4>

                            <ul class="mt-4">
                                @php
                                    $primaryUseData = $lead->getMeta('primary_use');
                                @endphp
                                
                                @if (!empty($primaryUseData) && is_array($primaryUseData))
                                    @foreach ($primaryUseData as $useType => $details)
                                        <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                            {{ __('Primary Use:') }}
                                            <strong class="inline-flex font-medium text-black-1200">
                                                {{ \App\Enums\PrimaryUse::from($useType)->getLabel() }}
                                            </strong>
                                        </li>
                                        
                                        @if ($useType === 'residential_domestic' && is_array($details))
                                            @if (!empty($details['domestic_no_of_people']))
                                                <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                                    {{ __('No. of People:') }}
                                                    <strong class="inline-flex font-medium text-black-1200">{{ $details['domestic_no_of_people'] }}</strong>
                                                </li>
                                            @endif
                                            
                                            @if (!empty($details['domestin_no_of_bathrooms']))
                                                <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                                    {{ __('No. of Bathrooms:') }}
                                                    <strong class="inline-flex font-medium text-black-1200">{{ $details['domestin_no_of_bathrooms'] }}</strong>
                                                </li>
                                            @endif
                                            
                                            @if (isset($details['domestic_swimming_pool_garden']))
                                                <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                                    {{ __('Swimming Pool/Garden:') }}
                                                    <strong class="inline-flex font-medium text-black-1200">{{ $details['domestic_swimming_pool_garden'] ? __('Yes') : __('No') }}</strong>
                                                </li>
                                            @endif
                                        @endif
                                        
                                        @if ($useType === 'commercial_business' && is_array($details))
                                            @if (!empty($details['commercial_business_detail']))
                                                <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                                    {{ __('Business Details:') }}
                                                    <strong class="inline-flex font-medium text-black-1200">{{ $details['commercial_business_detail'] }}</strong>
                                                </li>
                                            @endif
                                        @endif
                                        
                                        @if ($useType === 'irrigation_agricultural' && is_array($details))
                                            @if (!empty($details['agriculture_irrigation_purpose']))
                                                <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                                    {{ __('Irrigation Purpose:') }}
                                                    <strong class="inline-flex font-medium text-black-1200">{{ $details['agriculture_irrigation_purpose'] }}</strong>
                                                </li>
                                            @endif
                                            
                                            @if (!empty($details['agriculture_area_size']))
                                                <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                                    {{ __('Area Size:') }}
                                                    <strong class="inline-flex font-medium text-black-1200">{{ $details['agriculture_area_size'] }}</strong>
                                                </li>
                                            @endif
                                        @endif
                                        
                                        @if ($useType === 'other' && is_array($details))
                                            @if (!empty($details['other_intented_use_detail']))
                                                <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                                    {{ __('Other Details:') }}
                                                    <strong class="inline-flex font-medium text-black-1200">{{ $details['other_intented_use_detail'] }}</strong>
                                                </li>
                                            @endif
                                        @endif
                                    @endforeach
                                @endif
                                
                                @if (!empty($lead->getMeta('is_new_construction_project')))
                                    <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                        {{ __('New Construction:') }}
                                        <strong class="inline-flex font-medium text-black-1200">{{ $lead->getMeta('is_new_construction_project') ? __('Yes') : __('No') }}</strong>
                                    </li>
                                @endif
                                @if (!empty($lead->getMeta('is_existing_water_well')))
                                    <li class="flex items-center justify-between text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                        {{ __('Existing Well:') }}
                                        <strong class="inline-flex font-medium text-black-1200">{{ $lead->getMeta('is_existing_water_well') ? __('Yes') : __('No') }}</strong>
                                    </li>
                                @endif
                            </ul>
                        </div>
                        <div class="p-4 rounded-2xl bg-gray-1400">
                            <div class="flex flex-col-reverse gap-4 justify-between items-start md:flex-row md:gap-0 md:items-center">
                                <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">{{ __('Well Pump Details') }} </h4>
                                <span class="inline-flex gap-1 items-center px-1.5 h-5 text-xs font-medium leading-4 rounded-full border border-solid text-green-1200 border-green-1200 bg-green-1300">
                                    {{ __('Estimate included') }}
                                </span>
                            </div>
                            <ul class="mt-4">
                                @if (!empty($lead->getMeta('water_quality_goals')))
                                    <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                        {{ __('Water Quality Goals:') }}
                                        <strong class="inline-flex font-medium text-black-1200">
                                            {{ \App\Enums\WaterQualityGoals::from($lead->getMeta('water_quality_goals')[0])->getLabel() }}
                                        </strong>
                                    </li>
                                @endif
                                @if (!empty($lead->getMeta('well_site_location')))
                                    <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                        {{ __('Well Site Location:') }}
                                        <strong class="inline-flex font-medium text-black-1200">
                                            {{ $lead->getMeta('well_site_location') }}
                                        </strong>
                                    </li>
                                @endif
                                @if (!empty($lead->getMeta('notes')))
                                    <li class="flex items-center justify-between border-b border-solid border-gray-1200 pb-2 mb-3 text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                        {{ __('Installation Notes:') }}
                                        <strong class="inline-flex font-medium text-black-1200">
                                            {{ $lead->getMeta('notes') }}
                                        </strong>
                                    </li>
                                @endif
                                @if ($lead->getMedia('attachments')->count() > 0)
                                    <li class="flex items-center justify-between text-mid-gray font-normal text-sm leading-5 tracking-[-0.084px]">
                                        Photos Uploaded:
                                        <strong class="inline-flex font-medium text-black-1200">
                                            {{ $lead->getMedia('attachments')->count() }} {{ $lead->getMedia('attachments')->count() === 1 ? 'File' : 'Files' }}
                                        </strong>
                                    </li>
                                @endif

                            </ul>
                        </div>
                    </div>
                    <div class="p-4 rounded-xl bg-gray-1400">
                        <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.084px]">{{ __('Your privacy is protected') }}</h4>
                        <p class="mt-1 text-xs font-normal leading-4 text-mid-gray">
                            {{ __('Your contact information andproject details are sent directly and securely to our office. We will reach out to you personally to discuss your water well drilling estimate.') }}
                        </p>
                    </div>
                </div>
                <div class="bg-white rounded-[22px] border-[12px] border-solid border-blue-1900/[0.5] md:p-8 p-6 mt-[26px] shadow-19xl max-w-[732px] w-full mx-auto">
                    <div class="text-center">
                        <h5 class="text-2xl font-medium leading-8 text-black-1200">
                            Who Are We? <br> Your Vancouver
                            Water Well Experts</h5>
                        <p class="mt-1 text-base font-normal leading-6 text-mid-gray">We invite you to learn more
                            about our company!</p>
                    </div>
                    <div class="grid grid-cols-1 gap-5 mt-8 md:grid-cols-2">
                        <div class="p-6 bg-white rounded-2xl border border-solid border-gray-1200">
                            <div class="md:min-h-[278px]">
                                <span class="inline-flex justify-center items-center px-2 h-6 text-xs font-medium leading-4 rounded-full border border-solid text-green-1200 bg-green-1300 border-green-1200">Well
                                    Drilling</span>
                                <h6 class="my-2 text-xl font-medium leading-7 text-black-1200">Fraser Valley Well
                                    Drilling & Pumps</h6>
                                <p class="text-base font-normal leading-6 text-mid-gray">Trust Over Task</p>
                                <ul class="my-8">
                                    <li class="flex gap-2 items-center mb-4">
                                        <span class="flex items-center justify-center w-[18px] h-[18px]">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                width="14"
                                                height="11"
                                                viewBox="0 0 14 11"
                                                fill="none">
                                                <path d="M13 1.5L4.75 9.75L1 6"
                                                    stroke="#525866"
                                                    stroke-width="2"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        <p class="text-mid-gray text-sm font-normal leading-5 tracking-[-0.084px]">
                                            Serving Pitt Meadows, BC</p>
                                    </li>
                                    <li class="flex gap-2 items-center mb-4">
                                        <span class="flex items-center justify-center w-[18px] h-[18px]">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                width="14"
                                                height="11"
                                                viewBox="0 0 14 11"
                                                fill="none">
                                                <path d="M13 1.5L4.75 9.75L1 6"
                                                    stroke="#525866"
                                                    stroke-width="2"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        <p class="text-mid-gray text-sm font-normal leading-5 tracking-[-0.084px]">
                                            Established in 2018</p>
                                    </li>
                                    <li class="flex gap-2 items-center">
                                        <span class="flex items-center justify-center w-[18px] h-[18px]">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                width="14"
                                                height="11"
                                                viewBox="0 0 14 11"
                                                fill="none">
                                                <path d="M13 1.5L4.75 9.75L1 6"
                                                    stroke="#525866"
                                                    stroke-width="2"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        <p class="text-mid-gray text-sm font-normal leading-5 tracking-[-0.084px]">
                                            Well Drilling Specialists</p>
                                    </li>
                                </ul>
                            </div>
                            <a href="#" class="text-white gap-3.5 font-medium text-sm leading-5 tracking-[-0.084px] h-11 w-full rounded-full border border-solid border-blue-1700 gradient  flex items-center justify-center">
                                Learn more about us
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    width="7"
                                    height="10"
                                    viewBox="0 0 7 10"
                                    fill="none">
                                    <path d="M4.296 4.99956L0.583496 1.28706L1.644 0.226562L6.417 4.99956L1.644 9.77256L0.583496 8.71206L4.296 4.99956Z" fill="white" />
                                </svg>
                            </a>
                        </div>
                        <div class="p-6 bg-white rounded-2xl border border-solid border-gray-1200">
                            <div class="md:min-h-[278px]">
                                <span class="inline-flex justify-center items-center px-2 h-6 text-xs font-medium leading-4 rounded-full border border-solid text-primary-blue bg-blue-1200 border-primary-blue">Pump
                                    Installation</span>
                                <h6 class="my-2 text-xl font-medium leading-7 text-black-1200">Integra Water System
                                </h6>
                                <p class="text-mid-gray text-[15px] font-normal leading-6">We Share More Than A
                                    Community</p>
                                <ul class="my-8">
                                    <li class="flex gap-2 items-center mb-4">
                                        <span class="flex items-center justify-center w-[18px] h-[18px]">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                width="14"
                                                height="11"
                                                viewBox="0 0 14 11"
                                                fill="none">
                                                <path d="M13 1.5L4.75 9.75L1 6"
                                                    stroke="#525866"
                                                    stroke-width="2"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        <p class="text-mid-gray text-sm font-normal leading-5 tracking-[-0.084px]">
                                            Serving Vancouver, BC</p>
                                    </li>
                                    <li class="flex gap-2 items-center mb-4">
                                        <span class="flex items-center justify-center w-[18px] h-[18px]">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                width="14"
                                                height="11"
                                                viewBox="0 0 14 11"
                                                fill="none">
                                                <path d="M13 1.5L4.75 9.75L1 6"
                                                    stroke="#525866"
                                                    stroke-width="2"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        <p class="text-mid-gray text-sm font-normal leading-5 tracking-[-0.084px]">
                                            Established in 1988</p>
                                    </li>
                                    <li class="flex gap-2 items-center">
                                        <span class="flex items-center justify-center w-[18px] h-[18px]">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                width="14"
                                                height="11"
                                                viewBox="0 0 14 11"
                                                fill="none">
                                                <path d="M13 1.5L4.75 9.75L1 6"
                                                    stroke="#525866"
                                                    stroke-width="2"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        <p class="text-mid-gray text-sm font-normal leading-5 tracking-[-0.084px]">
                                            Pump Installation Specialists</p>
                                    </li>
                                </ul>
                            </div>
                            <a href="#" class="text-white gap-3.5 font-medium text-sm leading-5 tracking-[-0.084px] h-11 w-full rounded-full border border-solid border-blue-1700 gradient  flex items-center justify-center">
                                Learn more about us
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    width="7"
                                    height="10"
                                    viewBox="0 0 7 10"
                                    fill="none">
                                    <path d="M4.296 4.99956L0.583496 1.28706L1.644 0.226562L6.417 4.99956L1.644 9.77256L0.583496 8.71206L4.296 4.99956Z" fill="white" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="bg-white rounded-[22px] border-[12px] border-solid border-blue-1900/[0.5] md:p-8 p-6 mt-[26px] shadow-19xl max-w-[732px] w-full mx-auto">
                    <div class="mb-8 text-center">
                        <h5 class="text-2xl font-medium leading-8 text-black-1200">
                            {{ __('What Happens Next') }}
                        </h5>
                    </div>
                    <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                        <div class="border border-solid border-gray-1200 text-center rounded-[18px] bg-white p-4">
                            <span class="flex items-center justify-center text-white text-base font-medium leading-6 tracking-[-0.176px] rounded-full bg-primary-blue w-8 h-8 mx-auto">1</span>
                            <h5 class="text-black-1200 mt-3 mb-1.5 font-medium text-base leading-6 tracking-[-0.176px]">
                                Project Review</h5>
                            <p class="text-mid-gray md:max-w-[240px] w-full mx-auto font-normal text-base leading-6">
                                Our estimating team carefully evaluates your property details and project
                                requirements.</p>
                        </div>
                        <div class="border border-solid border-gray-1200 text-center rounded-[18px] bg-white p-4">
                            <span class="flex items-center justify-center text-white text-base font-medium leading-6 tracking-[-0.176px] rounded-full bg-primary-blue w-8 h-8 mx-auto">2</span>
                            <h5 class="text-black-1200 mt-3 mb-1.5 font-medium text-base leading-6 tracking-[-0.176px]">
                                Personal Contact</h5>
                            <p class="text-mid-gray md:max-w-[240px] w-full mx-auto font-normal text-base leading-6">
                                Expect a call or email from our office within 24-48 hours to discuss your project
                                and answer questions.
                            </p>
                        </div>
                    </div>
                    <div class="border mt-5 border-solid border-gray-1200 text-center rounded-[18px] bg-white p-4">
                        <span class="flex items-center justify-center text-white text-base font-medium leading-6 tracking-[-0.176px] rounded-full bg-primary-blue w-8 h-8 mx-auto">2</span>
                        <h5 class="text-black-1200 mt-3 mb-1.5 font-medium text-base leading-6 tracking-[-0.176px]">
                            Estimate Delivery</h5>
                        <p class="mx-auto w-full text-base font-normal leading-6 text-mid-gray">
                            We'll email you a detailed, site-specific well drilling cost estimate for your complete
                            water well system including pump if also requested.
                        </p>
                    </div>
                </div>
                <div class="flex items-center gap-5 justify-center ,d:mt-[52px] mt-9">
                    <a href="#" class="prev-btn text-mid-gray gap-3 font-medium text-sm leading-5 tracking-[-0.084px] h-10 w-[102px] rounded-full bg-white border border-solid border-gray-1200 flex items-center justify-center">
                        View FAQ's
                    </a>
                    <a href="#" class="next-btn text-white font-medium text-sm leading-5 tracking-[-0.084px] h-10 w-[205px] rounded-full bg-black-1200 flex items-center justify-center">Learn About Water Testing</a>
                </div>

            </div>
        </div>
    </div>
@endsection
