<div>
    <div class="relative bg-white">
        <a href="javascript:void(0)"
            onclick="Livewire.dispatch('closeModal')"
            class="flex absolute top-3 right-3 justify-center items-center w-6 h-6 md:top-6 md:right-6">
            <x-icon-close-icon />
        </a>

        <!-- Modal body -->
        <div class="p-5 sm:p-10">
            <div class="mb-6 text-center">
                <a href="#" class="flex justify-center items-center mb-5">
                    {!! Theme::image('img/esp-logo.svg', 'My Theme logo', 'md:h-auto h-16') !!}
                </a>
                <h5 class="mb-1 text-lg font-medium leading-6 text-black-1200 md:text-2xl md:leading-8">
                    {{ __('Welcome Back!') }} 👋</h5>
                <p class="text-sm font-normal leading-6 text-mid-gray md:text-base">
                    {{ __('Sign in to your ESP marketplace account.') }}
                </p>
            </div>
            <form wire:submit.prevent="authenticate">
                <div class="mb-4">
                    <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                        {{ __('Email') }} <spa class="text-primary-blue">*</span>
                    </label>
                    <div class="relative">
                        <input type="text"
                            class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-10 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                            placeholder="{{ __('hello@gmail.com') }}"
                            wire:model="email" />
                        <span class="flex absolute left-3 top-1/2 justify-center items-center w-5 h-5 -translate-y-1/2">
                            <x-icon-email2 />
                        </span>
                    </div>
                    @error('email')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mb-4">
                    <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                        {{ __('Password') }} <spa class="text-primary-blue">*</span>
                    </label>
                    <div class="relative">
                        <input type="{{ $showPassword ? 'text' : 'password' }}"
                            class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-10 pr-10 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                            placeholder="• • • • • • • • • •"
                            wire:model="password" />
                        <span class="flex absolute left-3 top-1/2 justify-center items-center w-5 h-5 -translate-y-1/2">
                            <x-icon-lock-icon />
                        </span>
                        <button type="button"
                            wire:click="togglePasswordVisibility"
                            x-data="{ clicked: false }"
                            x-on:click="clicked = true; setTimeout(() => clicked = false, 150)"
                            x-bind:class="clicked ? 'scale-95' : 'scale-100'"
                            class="flex absolute right-3 top-1/2 justify-center items-center w-5 h-5 transition-all duration-150 transform -translate-y-1/2 cursor-pointer hover:opacity-70"
                            title="{{ $showPassword ? __('Hide password') : __('Show password') }}">
                            @if ($showPassword)
                                <!-- Eye with slash (password visible - click to hide) -->
                                <x-icon-eye-slash />
                            @else
                                <!-- Regular eye (password hidden - click to show) -->
                                <x-icon-eye-regular />
                            @endif
                        </button>
                    </div>
                    @error('password')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="flex justify-between items-center mb-6">
                    <div class="flex items-center">
                        <input id="remember"
                            type="checkbox"
                            wire:model="remember"
                            class="w-[13px] h-[13px] bg-transparent shadow-9xl rounded-sm text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                        <label for="remember" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ __('Remember me') }}</label>
                    </div>
                    <a href="javascript:void(0)"
                        data-modal-target="default-modal12"
                        data-modal-toggle="default-modal12"
                        data-modal-hide="default-modal7"
                        x-on:click="
                            Livewire.dispatch('openModal', { 
                                component: 'frontend.auth.modal.password-forgot-modal',
                            });"
                        class="inline-flex text-black-1200 text-sm font-medium leading-5 tracking-[-0.096px] underline">{{ __('Forgot Password?') }}
                    </a>
                </div>
                <div class="flex justify-start mb-4">
                    <x-captcha-livewire-field wire-model="captchaToken"
                        action="login"
                        :show-error="true"
                        version="v3"
                        field-class="flex justify-center" />
                    @error('captchaToken')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mb-6">
                    <button type="submit"
                        class="w-full cursor-pointer primary-btn"
                        wire:loading.attr="disabled"
                        wire:target="authenticate"
                        wire:loading.class="opacity-50 cursor-not-allowed">
                        <span wire:loading.remove wire:target="authenticate">{{ __('Login') }}</span>
                        <span wire:loading wire:target="authenticate">
                            <div class="flex gap-2 justify-center items-center h-full">
                                <x-icon-loading-circle class="w-5 h-5 animate-spin" />
                                {{ __('Login...') }}
                            </div>
                        </span>
                    </button>
                </div>
                <div class="relative mb-6 flex items-center justify-center after:absolute after:content-[''] after:left-0 after:top-1/2 after:-translate-y-1/2 after:w-full after:h-px after:bg-gray-1200">
                    <span class="inline-flex items-center justify-center bg-white text-gray-1500 text-[11px] font-medium tracking-[0.32px] relative z-50 px-2.5">OR</span>
                </div>
                <div class="mb-6">

                    <ul class="grid grid-cols-4 gap-3">
                        <li><a href="#" class="flex justify-center items-center w-full h-10 rounded-full border border-solid border-gray-1200">
                                <x-icon-facebook-round />
                            </a></li>
                        <li><a href="#" class="flex justify-center items-center w-full h-10 rounded-full border border-solid border-gray-1200">
                                <x-icon-apple-icon />
                            </a></li>
                        <li><a href="#" class="flex justify-center items-center w-full h-10 rounded-full border border-solid border-gray-1200">
                                <x-icon-google-icon />
                            </a></li>
                        <li><a href="#" class="flex justify-center items-center w-full h-10 rounded-full border border-solid border-gray-1200">
                                <x-icon-linkdin2 />
                            </a></li>
                    </ul>
                </div>
                <div class="">
                    <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.096px] flex items-center gap-1 justify-center">
                        {{ __('Don’t have an account?') }}
                        <a href="javascript:void(0)"
                            x-data="{}"
                            x-on:click="
                                Livewire.dispatch('openModal', { 
                                    component: 'frontend.auth.modal.register-modal',
                                });"
                            class="inline-flex underline text-primary-blue">
                            {{ __('Create an Account') }}
                        </a>
                    </p>
                </div>

            </form>
        </div>

    </div>

</div>
