<div>
    <div class="relative bg-white rounded-3xl">
        <a href="javascript:void(0)"
            onclick="Livewire.dispatch('closeModal')"
            class="flex absolute top-3 right-3 justify-center items-center w-6 h-6 md:top-6 md:right-6">
            <x-icon-close-icon />
        </a>

        <!-- Modal body -->
        <div class="sm:p-10 p-5">
            <div class="text-center mb-6">
                <a href="javascript:void(0)" class="flex items-center justify-center mb-5">
                    {!! Theme::image('img/esp-logo.svg', 'My Theme logo', 'md:h-auto h-16') !!}
                </a>
                <h5 class="text-black-1200 font-medium md:text-2xl text-lg md:leading-8 leading-6 mb-1">Forgot Password 🔑</h5>
                <p class="text-mid-gray font-normal md:text-base text-sm leading-6">Enter your email and we'll send you a reset link.</p>
            </div>

            @if (session()->has('status'))
                <div class="mb-4 p-4 rounded-lg bg-green-50 text-green-700">
                    {{ session('status') }}
                </div>
            @endif

            <form wire:submit="sendPasswordResetLink">
                <div class="mb-4">
                    <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                        {{ __('Email') }} <span class="text-primary-blue">*</span>
                    </label>
                    <div class="relative">
                        <input type="email"
                            wire:model="email"
                            class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-10 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                            placeholder="{{ __('hello@gmail.com') }}" />
                        <span class="flex items-center justify-center w-5 h-5 absolute left-3 top-1/2 -translate-y-1/2"><x-icon-email2 /></span>
                    </div>
                    @error('email')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <button type="submit"
                        wire:loading.attr="disabled"
                        class="primary-btn w-full cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed">
                        <span wire:loading.remove>{{ __('Reset Password') }}</span>
                        <span wire:loading>{{ __('Sending...') }}</span>
                    </button>
                    
                    <button type="button"
                        wire:click="$dispatch('openModal', { component: 'frontend.auth.modal.login-modal' })"
                        class="w-full h-10 flex items-center justify-center text-mid-gray text-sm font-medium leading-5 tracking-[-0.096px] gap-2 mt-3">
                        <x-icon-left-arrow2/>
                        {{ __('Back to Login') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
    {{-- <div class="flex justify-between items-center pb-3">
        <p class="text-2xl font-bold">Forgot Password</p>
        <div class="cursor-pointer z-50" wire:click="closeModal">
            <svg class="fill-current text-black" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                <path d="M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z"></path>
            </svg>
        </div>
    </div>

    <div class="my-4">
        <p class="text-gray-600 mb-4">
            Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.
        </p>

        @if (session()->has('status'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                <span class="block sm:inline">{{ session('status') }}</span>
            </div>
        @endif

        <form wire:submit.prevent="sendPasswordResetLink" class="space-y-4">
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                <input wire:model.defer="email" id="email" name="email" type="email" autocomplete="email" required
                       class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm placeholder-gray-400 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                @error('email') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
            </div>

            <div class="flex justify-end">
                <button type="submit"
                        class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Email Password Reset Link
                </button>
            </div>
        </form>
    </div> --}}
</div>
