<div>
    <div class="relative bg-white rounded-3xl">
        <a href="javascript:void(0)"
            onclick="Livewire.dispatch('closeModal')"
            class="flex absolute top-3 right-3 justify-center items-center w-6 h-6 md:top-6 md:right-6">
            <x-icon-close-icon />
        </a>

        <!-- Modal body -->
        <div class="p-5 sm:p-10">
            <div class="mb-6 text-center">
                <a href="#" class="flex justify-center items-center mb-5">
                    {!! Theme::image('img/esp-logo.svg', 'My Theme logo', 'md:h-auto h-16') !!}
                </a>
                <h5 class="mb-1 text-lg font-medium leading-6 text-black-1200 md:text-2xl md:leading-8">
                    {{ __('Get started with ESP') }}
                </h5>
                <p class="text-sm font-normal leading-6 text-mid-gray md:text-base">
                    @if ($currentStep == 1)
                        {{ __('What type of account do you want to create?') }}
                    @else
                        {{ __('Please add your details below.') }}
                    @endif
                </p>
            </div>
            @if (session()->has('success'))
                <div class="p-4 mb-4 text-sm text-green-700 bg-green-100 rounded-lg">
                    {{ session('success') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="p-4 mb-4 text-sm text-red-700 bg-red-100 rounded-lg">
                    {{ session('error') }}
                </div>
            @endif
            @if ($currentStep == 1)
                <!-- Step 1: Account Type Selection -->
                <div class="mb-4">
                    <div class="flex relative items-center mb-3">
                        <input id="homeowner-radio"
                            type="radio"
                            value="homeowner"
                            wire:model.live="accountType"
                            class="sr-only">
                        <label for="homeowner-radio"
                            class="flex gap-3 items-center p-3 w-full rounded-xl border border-solid transition-colors cursor-pointer relative"
                            :class="$wire.accountType === 'homeowner' ? 'border-primary-blue bg-blue-1200' : 'border-gray-1200 hover:border-primary-blue'">
                            <span class="flex justify-center items-center w-10 h-10 rounded-full border border-solid shadow-3xl border-gray-1200">
                                <x-icon-home class="w-5 h-5 text-gray-600" />
                            </span>
                            <div class="flex-1 w-full">
                                <h4 class="text-black-1200 font-medium text-sm leading-5 mb-1 tracking-[-0.096px]">{{ __('Homeowner') }}</h4>
                                <p class="text-xs font-normal leading-4 text-mid-gray">{{ __("I'm looking for services") }}</p>
                            </div>
                            <div class="absolute right-4 top-1/2 -translate-y-1/2 w-4 h-4 rounded-full border-2 border-gray-300 bg-white flex items-center justify-center"
                                :class="$wire.accountType === 'homeowner' ? 'border-primary-blue' : 'border-gray-300'">
                                <div x-show="$wire.accountType === 'homeowner'" class="w-2 h-2 bg-primary-blue rounded-full"></div>
                            </div>
                        </label>
                    </div>
                    <div class="flex relative items-center">
                        <input id="service-provider-radio"
                            type="radio"
                            value="service-provider"
                            wire:model.live="accountType"
                            class="sr-only">
                        <label for="service-provider-radio"
                            class="flex gap-3 items-center p-3 w-full rounded-xl border border-solid transition-colors cursor-pointer relative"
                            :class="$wire.accountType === 'service-provider' ? 'border-primary-blue bg-blue-1200' : 'border-gray-1200 hover:border-primary-blue'">
                            <span class="flex justify-center items-center w-10 h-10 rounded-full border border-solid shadow-3xl border-gray-1200">
                                <x-icon-service class="w-5 h-5 text-gray-600" />
                            </span>
                            <div class="flex-1 w-full">
                                <h4 class="text-black-1200 font-medium text-sm leading-5 mb-1 tracking-[-0.096px]">{{ __('Service Provider') }}</h4>
                                <p class="text-xs font-normal leading-4 text-mid-gray">{{ __('I want to offer my services') }}</p>
                            </div>
                            <div class="absolute right-4 top-1/2 -translate-y-1/2 w-4 h-4 rounded-full border-2 border-gray-300 bg-white flex items-center justify-center"
                                :class="$wire.accountType === 'service-provider' ? 'border-primary-blue' : 'border-gray-300'">
                                <div x-show="$wire.accountType === 'service-provider'" class="w-2 h-2 bg-primary-blue rounded-full"></div>
                            </div>
                        </label>
                    </div>
                    @error('accountType')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>

                <div class="mb-6">
                    <button type="button"
                        wire:click="nextStep"
                        class="w-full cursor-pointer primary-btn">
                        <span wire:loading.remove wire:target="nextStep">{{ __('Continue') }}</span>
                        <span wire:loading wire:target="nextStep">
                            <div class="flex gap-2 justify-center items-center h-full">
                                <x-icon-loading-circle class="w-5 h-5 animate-spin" />
                                {{ __('Continue...') }}
                            </div>
                        </span>
                    </button>
                </div>

                <div class="">
                    <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.096px] flex items-center gap-1 justify-center">
                        {{ __('Already have an account?') }} <a href="javascript:void(0)"
                            x-data="{}"
                            x-on:click="
                                Livewire.dispatch('openModal', { 
                                    component: 'frontend.auth.modal.login-modal',
                                });"
                            class="inline-flex underline text-primary-blue">
                            {{ __('Sign in') }}
                        </a>
                    </p>
                </div>
            @else
                <!-- Step 2: Registration Form -->
                <form wire:submit.prevent="register">
                    <input type="hidden" wire:model="role">
                    <input type="hidden" wire:model="accountType">

                    <div class="mb-4">
                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                            {{ __('Full Name') }} <span class="text-primary-blue">*</span>
                        </label>
                        <div class="relative">
                            <input type="text"
                                wire:model.lazy="name"
                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3
                                 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                placeholder="{{ __('e.g John Doe') }}" />
                            @error('name')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="mb-4">
                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                            {{ __('Email') }} <span class="text-primary-blue">*</span>
                        </label>
                        <div class="relative">
                            <input type="email"
                                wire:model.lazy="email"
                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3
                                 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                placeholder="{{ __('hello@gmail.com') }}" />
                            @error('email')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="mb-6">
                        <label class="flex items-center font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                            {{ __('Phone Number') }}
                            <span class="text-primary-blue">*</span>
                        </label>
                        <input type="tel"
                            x-data
                            x-mask="(999) 999-9999"
                            wire:model.lazy="phone"
                            class="phone border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500"
                            placeholder="(555) 000-0000" />
                        <p class="mt-2 text-xs text-gray-500 output"></p>
                        @error('phone')
                            <span class="text-sm text-red-500">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="mb-4">
                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                            {{ __('Password') }} <span class="text-primary-blue">*</span>
                        </label>
                        <div class="relative">
                            <input type="{{ $showPassword ? 'text' : 'password' }}"
                                wire:model.lazy="password"
                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-10 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                placeholder="• • • • • • • • • • " />
                            <span class="flex absolute left-3 top-1/2 justify-center items-center w-5 h-5 -translate-y-1/2">
                                <x-icon-lock-icon />
                            </span>

                            <button type="button"
                                wire:click="togglePasswordVisibility"
                                x-data="{ clicked: false }"
                                x-on:click="clicked = true; setTimeout(() => clicked = false, 150)"
                                x-bind:class="clicked ? 'scale-95' : 'scale-100'"
                                class="flex absolute right-3 top-1/2 justify-center items-center w-5 h-5 transition-all duration-150 transform -translate-y-1/2 cursor-pointer hover:opacity-70"
                                title="{{ $showPassword ? __('Hide password') : __('Show password') }}">
                                @if ($showPassword)
                                    <x-icon-eye-slash />
                                @else
                                    <x-icon-eye-regular />
                                @endif
                            </button>
                        </div>
                        @error('password')
                            <span class="text-sm text-red-500">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="mb-4">
                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                            {{ __('Confirm Password') }} <span class="text-primary-blue">*</span>
                        </label>
                        <div class="relative">
                            <input type="{{ $showPasswordConfirmation ? 'text' : 'password' }}"
                                wire:model.lazy="passwordConfirmation"
                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-10 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                placeholder="• • • • • • • • • • " />
                            <span class="flex absolute left-3 top-1/2 justify-center items-center w-5 h-5 -translate-y-1/2">
                                <x-icon-lock-icon />
                            </span>
                            <button type="button"
                                wire:click="togglePasswordConfirmationVisibility"
                                x-data="{ clicked: false }"
                                x-on:click="clicked = true; setTimeout(() => clicked = false, 150)"
                                x-bind:class="clicked ? 'scale-95' : 'scale-100'"
                                class="flex absolute right-3 top-1/2 justify-center items-center w-5 h-5 transition-all duration-150 transform -translate-y-1/2 cursor-pointer hover:opacity-70"
                                title="{{ $showPasswordConfirmation ? __('Hide password') : __('Show password') }}">
                                @if ($showPasswordConfirmation)
                                    <x-icon-eye-slash />
                                @else
                                    <x-icon-eye-regular />
                                @endif
                            </button>
                        </div>
                        @error('passwordConfirmation')
                            <span class="text-sm text-red-500">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="flex justify-start mb-4">
                        <x-captcha-livewire-field wire-model="captchaToken"
                            action="register"
                            :show-error="true"
                            version="v3"
                            field-class="flex justify-center" />
                        @error('captchaToken')
                            <span class="text-sm text-red-500">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="mb-6">
                        <button type="submit" class="w-full cursor-pointer primary-btn">
                            <span wire:loading.remove wire:target="register">{{ __('Create Account') }}</span>
                            <span wire:loading wire:target="register">
                                <div class="flex gap-2 justify-center items-center h-full">
                                    <x-icon-loading-circle class="w-5 h-5 animate-spin" />
                                    {{ __('Create Account...') }}
                                </div>
                            </span>
                        </button>
                        <button type="button"
                            wire:click="previousStep"
                            class="w-full h-10 flex items-center justify-center text-mid-gray text-sm font-medium leading-5 tracking-[-0.096px] gap-2 mt-3 hover:text-primary-blue transition-colors">
                            <x-icon-left-arrow2 />
                            {{ __('Back') }}
                        </button>
                    </div>

                    <div class="">
                        <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.096px] flex items-center gap-1 justify-center">
                            {{ __('Already have an account?') }} <a href="javascript:void(0)"
                                x-data="{}"
                                x-on:click="
                                    Livewire.dispatch('openModal', { 
                                        component: 'frontend.auth.modal.login-modal',
                                    });"
                                class="inline-flex underline text-primary-blue">
                                {{ __('Sign in') }}
                            </a>
                        </p>
                    </div>
                </form>
            @endif
        </div>

    </div>
</div>
