<div>

    <div class="my-10 mx-auto p-4 w-full max-w-[532px] max-h-full shadow-2xl rounded-3xl">
        <div class="relative bg-white rounded-3xl">
            {{-- <a href="javascript:void(0)"
                onclick="Livewire.dispatch('closeModal')"
                class="flex absolute top-3 right-3 justify-center items-center w-6 h-6 md:top-6 md:right-6">
                <x-icon-close-icon />
            </a> --}}
            <!-- Modal body -->
            <div class="sm:p-10 p-5">
                <div class="text-center mb-6">
                    <a href="javascript:void(0)" class="flex items-center justify-center mb-5">
                        {!! Theme::image('img/esp-logo.svg', 'My Theme logo', 'md:h-auto h-16') !!}
                    </a>
                    <h5 class="text-black-1200 font-medium md:text-2xl text-lg md:leading-8 leading-6 mb-1">
                        {{ __('Reset Password') }} 🔑</h5>
                    <p class="text-mid-gray font-normal md:text-base text-sm leading-6">
                        {{ __('Please enter your new password below.') }}
                    </p>
                </div>

                @if (session()->has('status'))
                    <div class="mb-4 p-4 rounded-lg bg-green-50 text-green-700">
                        {{ session('status') }}
                    </div>
                @endif

                <form wire:submit="resetPassword">
                    <input wire:model="token" type="hidden">

                    <div class="mb-4">
                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                            {{ __('Email') }} <span class="text-primary-blue">*</span>
                        </label>
                        <div class="relative">
                            <input type="email"
                                wire:model.lazy="email"
                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-10 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                placeholder="{{ __('hello@gmail.com') }}" />
                            <span class="flex items-center justify-center w-5 h-5 absolute left-3 top-1/2 -translate-y-1/2">
                                <x-icon-email2 />
                            </span>
                        </div>
                        @error('email')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                            {{ __('New Password') }} <span class="text-primary-blue">*</span>
                        </label>
                        <div class="relative">
                            <input type="password"
                                wire:model.lazy="password"
                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-10 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500"
                                placeholder="{{ __('Enter your new password') }}" />
                            <span class="flex items-center justify-center w-5 h-5 absolute left-3 top-1/2 -translate-y-1/2">
                                <x-icon-lock-icon />
                            </span>
                        </div>
                        @error('password')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                            {{ __('Confirm Password') }} <span class="text-primary-blue">*</span>
                        </label>
                        <div class="relative">
                            <input type="password"
                                wire:model.lazy="password_confirmation"
                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-10 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500"
                                placeholder="{{ __('Confirm your new password') }}" />
                            <span class="flex items-center justify-center w-5 h-5 absolute left-3 top-1/2 -translate-y-1/2">
                                <x-icon-lock-icon />
                            </span>
                        </div>
                        @error('password_confirmation')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <button type="submit"
                            wire:loading.attr="disabled"
                            class="primary-btn w-full cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed">
                            <span wire:loading.remove>{{ __('Reset Password') }}</span>
                            <span wire:loading>{{ __('Resetting...') }}</span>
                        </button>

                        {{-- <button type="button"
                            wire:click="$dispatch('openModal', { component: 'frontend.auth.modal.login-modal' })"
                            class="w-full h-10 flex items-center justify-center text-mid-gray text-sm font-medium leading-5 tracking-[-0.096px] gap-2 mt-3">
                            <x-icon-left-arrow2 />
                            {{ __('Back to Login') }}
                        </button> --}}
                    </div>
                </form>
            </div>
        </div>
    </div>

</div>
