<div class="max-w-[1310px] w-full  mx-auto lg:px-4 px-0" x-data="initClassifiedSearch()">
    <div>
        <div class="px-6 lg:px-0">
            <x-frontend.common.breadcrumb-v2 :name="$breadcrumbs['name']" :params="$breadcrumbs['params'] ?? null" />
            <div class="flex flex-col justify-between items-start mt-3 lg:flex-row lg:items-center">
                <div class="w-full lg:w-auto">
                    <h6>{{ $page->heading }} {{ __('Results') }}</h6>
                    <ul class="flex flex-col gap-2 items-start mt-1 sm:flex-row sm:items-center">
                        <li class="text-xs font-medium leading-4 text-mid-gray">
                            {{ __('Showing :first to :last of :total results', [
                                'first' => $classifieds->firstItem(),
                                'last' => $classifieds->lastItem(),
                                'total' => $classifieds->total(),
                            ]) }}
                            {{ $searchForTxt }}

                        </li>
                        {{-- <li class="flex gap-1.5 items-center text-xs font-medium leading-4 border-solid text-mid-gray sm:border-l border-gray-1200 sm:px-2">
                            <x-icon-refresh-icon-outline />
                            {{ __('Updated 5 minutes ago') }}
                        </li> --}}
                    </ul>
                </div>
                <div class="hidden gap-4 items-center lg:flex">
                    <x-frontend.includes.sort-dropdown-desktop :sort="$sort"
                        :sortText="$sortText"
                        component="frontend.classified.partials.classified-sort-dropdown" />
                </div>
            </div>
        </div>
    </div>
    <div class="lg:hidden block sticky top-0 z-[100] bg-white px-6 w-full pt-3.5 pb-2 border-b border-solid border-gray-1200">
        <ul class="grid grid-cols-2 gap-3">
            <li>
                <a href="#"
                    @click="$refs.mobileSortModal.showModal()"
                    class="flex items-center  h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                    <x-icon-sort-icon />
                    {{ __('Sort') }}
                </a>
            </li>
            <li>
                <a href="#"
                    @click="openFilter = !openFilter"
                    class="filter-btn flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                    <x-icon-list-bars />
                    {{ __('Filters') }}
                </a>
            </li>
        </ul>
    </div>
    <div class="flex flex-col-reverse gap-6 px-6 py-8 lg:flex-row xl:gap-8 lg:gap-4 lg:mt-8 lg:px-0 lg:py-0">
        <div class="lg:w-[318px] w-full">
            {{-- classified sidebar --}}
            <div :class="{ 'active': openFilter }" class="bg-white lg:shadow-5xl lg:rounded-2xl lg:mb-8 filter-box transition-all duration-700 ease-in-out lg:static lg:h-auto fixed -left-full top-0 w-full h-full z-[100]">
                <div x-data="{
                    openLocation: @entangle('openLocation').defer,
                    openClassifiedAdType: @entangle('openClassifiedAdType').defer,
                    openCondition: @entangle('openCondition').defer,
                    openCategory: @entangle('openCategory').defer,
                    openSubcategory: @entangle('openSubcategory').defer,
                    openSpecificServices: @entangle('openSpecificServices').defer,
                    openItemAge: @entangle('openItemAge').defer,
                    openPricing: @entangle('openPricing').defer,
                    openFlashSale: @entangle('openFlashSale').defer,
                    openSellerType: @entangle('openSellerType').defer,
                    openDatePosted: @entangle('openDatePosted').defer,
                    openTransactionAndDelivery: @entangle('openTransactionAndDelivery').defer,
                    openAdvancedFilters: @entangle('openAdvancedFilters').defer,
                }"
                    id="search-sidebar-{{ $this->getId() }}"
                    data-component-id="{{ $this->getId() }}"
                    data-country="{{ $countryCode ?: '' }}">
                    @include('components.frontend.classified.sidebar.search-sidebar')
                </div>
            </div>
            <div class="hidden lg:block">
                <x-frontend.sidebar.widgets.ads-alert />
            </div>
        </div>
        <div class="relative lg:w-[calc(100%_-_350px)] w-full">
            <div x-show="classifiedListLoading" class="absolute inset-0 z-50 w-full h-full bg-white backdrop-blur-sm">
                <x-frontend.includes.loading-overlay-list layout="classified-list"
                    rows="6"
                    class="mt-4" />
            </div>
            <div>
                @if ($classifieds->isNotEmpty())
                    @foreach ($classifieds as $classified)
                        <x-frontend.classified.classified-card :classified="$classified" lazy />
                        @if ($loop->iteration % 4 == 0)
                            <div class="mb-6">
                                @include('components.frontend.classified.partials.promotion-card')
                            </div>
                        @endif
                    @endforeach

                    @if ($classifieds->hasPages())
                        <div class="mt-9">
                            {{ $classifieds->links('vendor.livewire.esp-sleek-pagination') }}
                        </div>
                    @endif
                @else
                    <x-frontend.includes.no-records-found-v1>
                        <x-slot:icon>
                            <x-icon-search-icon />
                        </x-slot>
                        <x-slot:title>
                            {{ __('classifieds') }}
                        </x-slot>
                        <x-slot:description>
                            {{ __('classifieds') }}
                        </x-slot>
                    </x-frontend.includes.no-records-found-v1>
                @endif

            </div>
            <div class="mt-6">
                <x-frontend.classified.partials.ads-card />
            </div>
        </div>
    </div>

    <x-frontend.includes.sort-modal-mobile :sort="$sort"
        :sortText="$sortText"
        component="frontend.classified.partials.classified-sort-dropdown" />
</div>
