@php
    use ProtoneMedia\LaravelFFMpeg\Support\FFMpeg;
    use Illuminate\Support\Facades\Storage;
    use Illuminate\Support\Number;

    $videoFileUrl = $classified->getFirstMediaUrl('video');
    $media = $classified->media('video')->first();
    $duration = '0:10';
    // $videoPath = $media->getPath();
    // $duration = FFMpeg::fromDisk($media->disk)->open($media->getPathRelativeToRoot())->getDurationInSeconds();
    // $duration = gmdate('i:s', $duration);
@endphp
<!-- Main modal -->

<div class="relative bg-black md:rounded-3xl">
    <a href="javascript:void(0)"
        onclick="Livewire.dispatch('closeModal')"
        data-modal-hide="default-modal3"
        class="hidden absolute top-6 right-6 justify-center items-center w-6 h-6 md:flex md:right-4 md:top-4 text-white">
        <x-icon-close-icon />
    </a>

    <!-- Modal body -->
    <div class="md:p-10 sm:p-0">
        {{-- <div class="p-6">
            <a href="javascript:void(0)"
                onclick="Livewire.dispatch('closeModal')"
                class="flex items-center flex-start"
                data-modal-hide="default-modal3">
                <x-icon-arrow-left-outline />
            </a>
        </div> --}}
        <div class="flex items-center flex-col xl:h-[500px] md:h-[350px] h-[200px]">
            @if ($videoFileUrl)
                <video class="rounded-xl" controls>
                    <source src="{{ $videoFileUrl }}" type="video/mp4">
                    <source src="{{ $videoFileUrl }}" type="video/webp">
                    <source src="{{ $videoFileUrl }}" type="video/ogg">
                    <source src="{{ $videoFileUrl }}" type="video/ogv">
                    <source src="{{ $videoFileUrl }}" type="video/webm">
                    {{ __('Your browser does not support the video tag.') }}
                </video>
            @else
                <img src="{{ $videoFileUrl }}"
                    alt="{{ $videoFileUrl->title }}"
                    class="w-full h-full rounded-xl" />
            @endif
        </div>
        <div class="p-6 md:mt-12 md:p-0">
            <h5 class="text-xl font-medium leading-7 md:text-2xl md:leading-8 text-white">{{ str()->headline($classified->title) }}</h5>
        </div>
    </div>
</div>
