<div x-data="{
    openLocation: @entangle('openLocation').defer,
    openClassifiedAdType: @entangle('openClassifiedAdType').defer,
    openCategory: @entangle('openCategory').defer,
    openCondition: @entangle('openCondition').defer,
    openItemAge: @entangle('openItemAge').defer,
    openPricing: @entangle('openPricing').defer,
    openSellerTypeAndDatePosted: @entangle('openSellerTypeAndDatePosted').defer,
    openTransactionAndDelivery: @entangle('openTransactionAndDelivery').defer,
    openAdvancedFilters: @entangle('openAdvancedFilters').defer,
}" :class="{ 'active': openFilter }" class="filter-box bg-white lg:shadow-5xl lg:rounded-2xl lg:mb-8 filter-box transition-all duration-700 ease-in-out lg:static lg:h-auto fixed -left-full top-0 w-full h-full z-[100]">
    {{-- Classifieds Filter --}}
    <div class="bg-white border-solid lg:border border-gray-1200 lg:shadow-5xl lg:rounded-2xl">
        <div class="flex justify-between items-center px-6 pt-6 pb-3 border-b border-solid lg:pb-0 lg:border-0 border-gray-1200">
            <h6 class="hidden lg:block">
                {{ __(' Filter by') }}
            </h6>
            <h6 class="flex gap-3 items-center lg:hidden">
                <x-icon-filter-icon />
                {{ __('Filter') }}
                <span class="flex justify-center items-center w-6 h-6 text-xs font-medium text-white rounded-full bg-primary-blue">
                    4
                </span>
            </h6>
            <div class="flex gap-3 items-center">
                <a href="javascript:void(0)" wire:click="Livewire.dispatch('resetFilters')" class="flex text-primary-blue gap-2 items-center justify-center font-medium text-sm tracking-[-0.096px]">
                    <x-icon-close-icon class="hidden lg:block" />
                    {{ __('Clear all') }}
                </a>
                <a href="#" x-on:click="openFilter = false" class="flex justify-center items-center w-6 h-6 lg:hidden filter-close">
                    <x-icon-close-icon />
                </a>
            </div>
        </div>
        <div class="lg:px-px lg:h-auto lg:overflow-y-auto h-[calc(100vh_-_154px)] overflow-y-scroll">
            <div class="px-6 py-8 lg:py-6">
                <form>
                    <div>
                        <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Search') }}</h4>
                        <div class="relative mt-1">
                            <input type="text" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full pl-10" placeholder="{{ __('Search...') }}" />
                            <a href="#" class="flex absolute left-3.5 top-1/2 justify-center items-center -translate-y-1/2">
                                <x-icon-search-icon />
                            </a>
                        </div>
                    </div>
                    <div class="py-6 border-b border-solid border-gray-1600" x-data="{ openFlashSales: false }">
                        <a href="javascript:void(0)" class="flex justify-between items-center collapse-btn" @click="openFlashSales = !openFlashSales">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Category') }}</h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow2 />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openFlashSales }">
                            <ul>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="flash-sales" type="checkbox" value="{{ __('flash-sales') }}" wire:model.live="flashOnly" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="flash-sales" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                            {{ __('Flash Sales Only') }}
                                        </label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="new-items" type="checkbox" value="{{ __('new-items') }}" wire:model.live="newItems" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="new-items" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                            {{ __('New Items') }}
                                        </label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="local-pickup" type="checkbox" value="{{ __('local-pickup') }}" wire:model.live="localPickup" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="local-pickup" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                            {{ __('Local Pickup') }}
                                        </label>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="py-6 border-b border-solid border-gray-1600" x-data="{ openLocation: false }">
                        <a href="javascript:void(0)" class="flex justify-between items-center collapse-btn" @click="openLocation = !openLocation">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Location') }}</h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openLocation }">
                            @if ($countryList->isNotEmpty())
                                <ul>
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="country-{{ __('all') }}" type="radio" value="" wire:model.live="country" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="country-{{ __('all') }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                {{ __('All') }}
                                                <span class="text-xs leading-4 text-mid-gray">{{ __('540') }}</span>
                                            </label>
                                        </div>
                                    </li>
                                    @foreach ($countryList as $country)
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="country-{{ $country->slug }}" type="radio" wire:model.live="country" value="{{ $country->slug }}" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="country-{{ $country->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                    {{ $country->country_name }}
                                                    <span class="text-xs leading-4 text-mid-gray">{{ __('540') }}</span>
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>

                                @if (!empty($stateList))
                                    <div class="mb-4">
                                        <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">State</h4>
                                        <div class="relative mt-1">
                                            <select wire:model.live="state" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                                <option>{{ __('Select State') }}</option>
                                                @foreach ($stateList as $state)
                                                    <option value="{{ $state->slug }}">{{ $state->state_name }}</option>
                                                @endforeach
                                            </select>
                                            <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </div>
                                    </div>
                                @endif
                                @if (!empty($state))
                                    <div>
                                        <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                            {{ __('City or Zip') }}
                                        </h4>
                                        <div class="relative mt-1" x-data="{ lat: null, lng: null }">
                                            <input id="city-input-{{ $this->id() }}" wire:model="city" type="text" placeholder="Enter city or zip" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3" />
                                            @if ($city)
                                                <button type="button" x-on:click="$wire.set('city', null); $wire.set('lat', null); $wire.set('lng', null);" class="absolute right-4 top-1/2 text-gray-500 -translate-y-1/2 hover:text-gray-700 focus:outline-none" title="{{ __('Clear') }}">
                                                    <x-icon-clear-field class="w-5 h-5" />
                                                </button>
                                            @endif
                                            <input type="hidden" id="lat-{{ $this->id() }}" wire:model="lat" x-model="lat" />
                                            <input type="hidden" id="lng-{{ $this->id() }}" wire:model="lng" x-model="lng" />
                                            {{-- Clear icon that only appears when there's a value --}}
                                        </div>

                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)" @click="openClassifiedAdType = !openClassifiedAdType" class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Classified Ad Type') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow2 />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openClassifiedAdType }">
                            <ul>
                                @foreach ($typeList->take(5) as $type)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="type-{{ $type->slug }}" type="checkbox" value="{{ $type->slug }}" wire:model.live="type" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="type-{{ $type->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ $type->classified_type_name }}</label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                            @if ($typeList->count() > 5)
                                <div x-data="{ showAllTypes: false }">
                                    <div x-show="showAllTypes" x-transition:enter="transition duration-300 ease-in-out" x-transition:enter-start="opacity-0 transform -translate-y-2" x-transition:enter-end="opacity-100 transform translate-y-0">
                                        <ul>
                                            @foreach ($typeList->skip(5) as $type)
                                                <li>
                                                    <div class="flex items-center mb-2">
                                                        <input id="type-{{ $type->slug }}" type="checkbox" value="{{ $type->slug }}" wire:model.live="type" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                        <label for="type-{{ $type->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ $type->classified_type_name }}</label>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>

                                    <a @click="showAllTypes = !showAllTypes" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                        <span x-text="showAllTypes ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($typeList) }}'"></span>
                                        <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllTypes }">
                                            <x-icon-down-arrow-outline />
                                        </span>
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                    {{-- Category & Subcategory --}}
                    @if (!empty($mainCategoryList))
                        <div class="py-6 border-b border-solid border-gray-1600">
                            <a href="javascript:void(0)" @click="openCategory = !openCategory" class="flex justify-between items-center collapse-btn">
                                <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]" @click="openCategory=!openCategory">
                                    {{ __('Category & Subcategory') }}
                                </h4>
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                            @if (!empty($mainCategoryList) || !empty($subCategoryList))
                                <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openCategory }">
                                    <div class="mb-4">
                                        <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                            {{ __('Main Category') }}
                                        </h4>
                                        <div class="relative mt-1">
                                            <select wire:model.live="mainCategory" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                                <option>{{ __('Select main category') }}</option>
                                                @foreach ($mainCategoryList as $mainCategory)
                                                    <option value="{{ $mainCategory->slug }}">{{ $mainCategory->classified_category_name }}</option>
                                                @endforeach
                                            </select>
                                            <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </div>
                                    </div>
                                    @if ($subCategoryList->count() > 0)
                                        <div>
                                            <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                                {{ __('Subcategory') }}
                                            </h4>
                                            <div class="relative mt-1">
                                                <select wire:model.live="subCategory" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                                    <option>{{ __('Select subcategory') }}</option>
                                                    @foreach ($subCategoryList as $subCategory)
                                                        <option value="{{ $subCategory->slug }}">{{ $subCategory->classified_subcategory_name }}</option>
                                                    @endforeach
                                                </select>
                                                <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                                    <x-icon-down-arrow-outline />
                                                </span>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif
                        </div>
                    @endif
                    {{-- Condition --}}
                    @if (!empty($conditionList))
                        <div class="py-6 border-b border-solid border-gray-1600">
                            <a href="javascript:void(0)" class="flex justify-between items-center collapse-btn" @click="openCondition = !openCondition">
                                <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                    {{ __('Condition') }}
                                </h4>
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                            <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openCondition }">
                                <ul>
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="condition-all" type="radio" value="" wire:model.live.debounce.150ms="condition" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="condition-all" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ __('All') }}</label>
                                        </div>
                                    </li>
                                    @foreach (\Illuminate\Support\Arr::take($conditionList, 5) as $condition)
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="condition-{{ $condition->value }}" type="radio" value="{{ $condition->value }}" wire:model.live.debounce.150ms="condition" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="condition-{{ $condition->value }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ $condition->getLabel() }}</label>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>

                                @if (!empty($conditionList))
                                    <div x-data="{ showAllConditions: false }">
                                        <div x-show="showAllConditions" x-transition:enter="transition duration-300 ease-in-out" x-transition:enter-start="opacity-0 transform -translate-y-2" x-transition:enter-end="opacity-100 transform translate-y-0">
                                            <ul>
                                                @foreach (array_slice($conditionList, 5) as $condition)
                                                    <li>
                                                        <div class="flex items-center mb-2">
                                                            <input id="condition-{{ $condition->value }}" type="radio" value="{{ $condition->value }}" wire:model.live="condition" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                            <label for="condition-{{ $condition->value }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ $condition->getLabel() }}</label>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>

                                        <a @click="showAllConditions = !showAllConditions" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                            <span x-text="showAllConditions ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($conditionList) }}'"></span>
                                            <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllConditions }">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif
                    @if (!empty($itemAgeList))
                        <div class="py-6 border-b border-solid border-gray-1600">
                            <a href="javascript:void(0)" @click="openItemAge = !openItemAge" class="flex justify-between items-center collapse-btn">
                                <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                    {{ __('Item Age') }}
                                </h4>
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                            <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openItemAge }">
                                @if (!empty($itemAgeList))
                                    <ul>
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="any" type="radio" value="" wire:model.live="itemAge" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="any" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                    {{ __('Any') }}
                                                </label>
                                            </div>
                                        </li>
                                        @foreach ($itemAgeList as $itemAge)
                                            <li>
                                                <div class="flex items-center mb-2">
                                                    <input id="{{ $itemAge['value'] }}" type="radio" value="{{ $itemAge['value'] }}" wire:model.live="itemAge" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="{{ $itemAge['value'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $itemAge['name'] }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                    @endif

                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)" @click="openPricing = !openPricing" class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Pricing') }}</h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openPricing }">
                            <ul>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox27" type="checkbox" value="" checked="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox27" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Open
                                            Now <span class="text-xs leading-4 text-mid-gray">540</span></label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox28" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox28" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Verified
                                            Only <span class="text-xs leading-4 text-mid-gray">326</span></label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox29" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox29" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">With
                                            Customer Reviews <span class="text-xs leading-4 text-mid-gray">326</span></label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox30" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox30" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Emergency
                                            (24/7) <span class="text-xs leading-4 text-mid-gray">326</span></label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center">
                                        <input id="default-checkbox31" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox31" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">5
                                            stars <span class="text-xs leading-4 text-mid-gray">87</span></label>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    @if (!empty($flashFilterList))
                        <div class="py-6 border-b border-solid border-gray-1600" x-data="{ openFlashSale: false }">
                            <a href="javascript:void(0)" @click="openFlashSale = !openFlashSale" class="flex justify-between items-center collapse-btn">
                                <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                    {{ __('Flash Sale') }}
                                </h4>
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                            <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openFlashSale }">
                                @if (!empty($flashFilterList))
                                    <ul>
                                        @foreach ($flashFilterList->take(5) as $flashFilter)
                                            <li>
                                                <div class="flex items-center mb-2">
                                                    <input id="{{ $flashFilter['id'] }}" type="checkbox" value="{{ $flashFilter['id'] }}" wire:model.live="flashFilter" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="{{ $flashFilter['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                        {{ $flashFilter['name'] }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>

                                    <div x-data="{ showAllFlashFilters: false }">
                                        <div x-show="showAllFlashFilters" x-transition:enter="transition duration-300 ease-in-out" x-transition:enter-start="opacity-0 transform -translate-y-2" x-transition:enter-end="opacity-100 transform translate-y-0">
                                            <ul>
                                                @foreach ($flashFilterList->skip(5) as $flashFilter)
                                                    <li>
                                                        <div class="flex items-center mb-2">
                                                            <input id="{{ $flashFilter['id'] }}" type="checkbox" value="{{ $flashFilter['id'] }}" wire:model.live="flashFilter" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                            <label for="{{ $flashFilter['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                                {{ $flashFilter['name'] }}
                                                            </label>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>

                                        <a @click="showAllFlashFilters = !showAllFlashFilters" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                            <span x-text="showAllFlashFilters ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($flashFilterList) }}'"></span>
                                            <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllFlashFilters }">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif
                    @if (!empty($sellerTypeList))
                        <div class="py-6 border-b border-solid border-gray-1600" x-data="{ openSellerType: false }">
                            <a href="javascript:void(0)" class="flex justify-between items-center collapse-btn" @click="openSellerType = !openSellerType">
                                <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Seller Type') }}</h4>
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                            <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openSellerType }">
                                @if (!empty($sellerTypeList))
                                    <ul>
                                        @foreach ($sellerTypeList as $sellerType)
                                            <li>
                                                <div class="flex items-center mb-2">
                                                    <input id="{{ $sellerType->value }}" type="checkbox" value="{{ $sellerType->value }}" wire:model.live="sellerType" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="{{ $sellerType->value }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                        {{ $sellerType->getLabel() }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach

                                    </ul>
                                @endif
                            </div>
                        </div>
                    @endif
                    @if (!empty($datePostedList))
                        <div class="py-6 border-b border-solid border-gray-1600" x-data="{ openDatePosted: false }">
                            <a href="javascript:void(0)" class="flex justify-between items-center collapse-btn" @click="openDatePosted = !openDatePosted">
                                <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Date Posted') }}</h4>
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                            <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openDatePosted }">
                                @if (!empty($datePostedList))
                                    <ul>
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="any" type="radio" value="" wire:model.live="datePosted" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="any" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                    {{ __('Any') }}
                                                </label>
                                            </div>
                                        </li>
                                        @foreach ($datePostedList as $datePosted)
                                            <li>
                                                <div class="flex items-center mb-2">
                                                    <input id="{{ $datePosted['id'] }}" type="radio" value="{{ $datePosted['id'] }}" wire:model.live="datePosted" class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="{{ $datePosted['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                        {{ $datePosted['name'] }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                    @endif
                    {{-- @if (!empty($transactionAndDeliveryList)) --}}
                        <div class="py-6 border-b border-solid border-gray-1600" x-data="{ openTransactionAndDelivery: false }">
                            <a href="javascript:void(0)" class="flex justify-between items-center collapse-btn" @click="openTransactionAndDelivery = !openTransactionAndDelivery">
                                <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                    {{ __('Transaction & Delivery') }}
                                </h4>
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </a>
                            <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openTransactionAndDelivery }">
                                <ul>
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="default-checkbox45" type="checkbox" value="" checked="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="default-checkbox45" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Local
                                                Pickup</label>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="default-checkbox46" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="default-checkbox46" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">shipping
                                                Available</label>
                                        </div>
                                    </li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox47" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox47" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Delivery
                                            Available</label>
                                    </div>
                                    </li>
                                    </li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox48" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox48" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">On-Site
                                            Only</label>
                                    </div>
                                    </li>
                                    </li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox49" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox49" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Must
                                            Remove</label>
                                    </div>
                                    </li>
                                    </li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox50" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox50" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Seller
                                            Will Transport</label>
                                    </div>
                                    </li>
                                    </li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox51" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox51" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Meet
                                            in Person</label>
                                    </div>
                                    </li>
                                </ul>
                                <a href="#" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue">Show
                                    all 12 <img src="images/down-arrow.svg" alt=""></a>
                            </div>
                        </div>
                    {{-- @endif --}}
                    <div class="pt-6" x-data="{ openAdvancedFilters: false }">
                        <a href="javascript:void(0)" @click="openAdvancedFilters = !openAdvancedFilters" class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Advanced Filters') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget" :class="{ 'active': !openAdvancedFilters }">
                            <ul>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox52" type="checkbox" value="" checked="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox52" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Trending
                                            Now</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="default-checkbox53" type="checkbox" value="" class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="default-checkbox53" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Recently
                                            Reduced Price</label>
                                    </div>
                            </ul>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="block absolute bottom-0 left-0 p-6 w-full bg-white border-t border-solid lg:hidden border-gray-1200">
            <a href="#" class="primary-btn">Show 200+ Results</a>
        </div>
    </div>
</div>
