<div>
    @if (!empty($heading))
        <h4 class="text-black-1200 text-center font-medium text-[32px] leading-10 tracking-[-0.08px] mb-4">
            {{ $heading }}
        </h4>
    @endif
    @if (!empty($description))
        <p class="text-mid-gray text-center font-normal text-base leading-6">
            {{ $description }}
        </p>
    @endif
    @if (!empty($categories))
        <ul class="grid md:grid-cols-3 sm:grid-cols-2 grid-cols-1 gap-6 max-w-[1248px] w-full mx-auto mt-16">
            @foreach ($categories as $category)
                <li>
                    <a href="{{ route('member.index', \Illuminate\Support\Arr::query(['category' => [$category->slug]])) }}" class="text-black-1200 px-4 font-medium text-base leading-6 tracking-[-0.176px] bg-gray-1400 rounded-2xl h-[68px] flex items-center justify-between">
                        {{ $category->category_name }}
                        <x-icon-right-top-arrow-blue />
                    </a>
                </li>
            @endforeach
        </ul>
    @endif
</div>
