<div>
    @if (!empty($heading))
        <h4 class="text-black-1200 font-medium sm:text-left text-center text-[32px] leading-10 tracking-[-0.08px] mb-4">
            {{ $heading }}
        </h4>
    @endif
    @if (!empty($description))
        <p class="text-mid-gray font-normal sm:text-lg text-base sm:text-left text-center leading-6 sm:tracking-[-0.24px] sm:max-w-full max-w-[250px] sm:mx-0 mx-auto">
            {{ $description }}
        </p>
    @endif
    @if (!empty($lists))
        <ul class="mt-16">
            @foreach ($lists as $list)
                <li class="flex gap-3.5 items-start mb-6 sm:gap-6">
                    <span class="flex justify-center items-center w-6 h-6">
                        <x-icon-check-double />
                    </span>
                    <p class="flex-1 w-full text-base font-normal leading-6 text-mid-gray lg:text-base sm:text-xs">
                        {{ $list['item'] }}
                    </p>
                </li>
            @endforeach

        </ul>
    @endif
</div>
