<div>
    @if (!empty($heading))
        <h4 class="text-black-1200 text-center font-medium text-[32px] leading-10 tracking-[-0.08px] mb-4">
            {{ $heading }}
        </h4>
    @endif
    @if (!empty($description))
        <p class="text-mid-gray text-center font-normal text-base leading-6">
            {{ $description }}
        </p>
    @endif
    @if (!empty($mainItems))
        <div class="grid md:grid-cols-3 sm:grid-cols-2 grid-cols-1 lg:gap-8 gap-4 mt-16 max-w-[1015px] w-full mx-auto">
            @foreach ($mainItems as $mainItem)
                <div class="bg-white rounded-3xl shadow-14xl xl:p-8 sm:p-5 p-8">
                    @if (!empty($mainItem['icon']))
                        <span class="flex items-center mb-[22px]">
                            @svg($mainItem['icon'])
                        </span>
                    @endif
                    @if (!empty($mainItem['heading']))
                        <h4 class="text-black-1200 font-medium lg:text-2xl sm:text-lg text-2xl leading-8">
                            {{ $mainItem['heading'] }}
                        </h4>
                    @endif
                    @if (!empty($mainItem['list']))
                        <ul class="mt-5">
                            @foreach ($mainItem['list'] as $childItem)
                                @if (!empty($childItem['item']))
                                    <li class="flex items-start gap-2 mb-2.5">
                                        <span class="flex items-center justify-center w-6 h-6"><x-icon-check-double /></span>

                                        <p class="text-mid-gray font-normal lg:text-base sm:text-xs text-base leading-6 flex-1 w-full">
                                            {{ $childItem['item'] }}
                                        </p>
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    @endif
                </div>
            @endforeach
        </div>
    @endif
</div>
