<div>
    @if (!empty($heading))
        <h4 class="text-black-1200 text-center font-medium text-[32px] leading-10 tracking-[-0.08px] mb-4">
            {{ $heading }}
        </h4>
    @endif
    @if (!empty($description))
        <p class="text-mid-gray text-center font-normal text-base leading-6">
            {{ $description }}
        </p>
    @endif
    @if (!empty($links))
        <ul class="flex mt-16 items-center justify-center flex-wrap gap-4 max-w-[1160px] w-full mx-auto">
            @foreach ($links as $link)
                <li>
                    <a href="{{ $link['link_url'] }}" class="group inline-flex items-center justify-center text-black-1200 font-semibold text-base leading-6 gap-2 border border-solid border-gray-1200 h-10 rounded-full md:px-4 px-[13px] hover:bg-white transition-all duration-500 ease-in-out">Water
                        {{ $link['link_text'] }}
                        <span class="flex items-center justify-center w-5 h-5">
                            <x-icon-right-top-arrow class="group-hover:rotate-[45deg] transition-all duration-500 ease-in-out" />
                        </span>
                    </a>
                </li>
            @endforeach
        </ul>
    @endif
</div>
