<div>
    <div class="max-w-[1310px] w-full mx-auto md:px-4 px-6">
        <div>
            <x-frontend.common.breadcrumb-v2 :name="$breadcrumbs['name']" :params="$breadcrumbs['params'] ?? null" />
            <div class="flex flex-col justify-between items-center md:flex-row">
                <div class="w-full md:w-auto">
                    <div class="flex gap-3 items-center my-3">
                        <span class="flex justify-center items-center p-1.5 w-12 h-12 rounded-2xl border border-solid border-gray-1200">
                            <x-frontend.member.profile.partials.profile-avatar :user="$job->author" />
                        </span>
                        <h4 class="text-xl font-medium leading-7 text-black-1200">
                            {{ $job->author->memberName() }}
                        </h4>
                    </div>
                    <div class="flex flex-col-reverse gap-3 items-start sm:flex-row sm:items-center">
                        <h5 class="text-xl font-medium leading-8 text-black-1200 md:text-2xl">
                            {{ $job->job_title }}
                        </h5>
                        @if ($job->isNew())
                            <span class="feature-tag">
                                {{ __('Newly Listed') }}
                            </span>
                        @endif
                    </div>
                    @if ($job->jobTypeName() || $job->saleryRange() || $job->jobCarerLevel() || $job->jobIndustry() || $job->jobRole())
                        <ul class="flex flex-wrap gap-2 items-center mt-3 md:flex-nowrap">
                            @if ($job->jobTypeName())
                                <li><a href="#" class="tags">{{ $job->jobTypeName() }}</a></li>
                            @endif
                            @if ($job->workMode())
                                <li><a href="#" class="tags">{{ $job->workMode() }}</a></li>
                            @endif
                            @if ($job->saleryRange())
                                <li><a href="#" class="tags">{{ $job->saleryRange() }}</a></li>
                            @endif
                            @if ($job->jobCarerLevel())
                                <li><a href="#" class="tags">{{ $job->jobCarerLevel() }}</a></li>
                            @endif
                            @if ($job->jobRole())
                                <li><a href="#" class="tags">{{ $job->jobRole() }}</a></li>
                            @endif
                        </ul>
                    @endif
                    <div class="mt-3">
                        @if ($job->address() || $job->postedDate() || $job->deadlineDate())
                            <ul class="flex flex-wrap gap-1.5 items-center sm:gap-2">
                                @if ($job->address())
                                    <li class="text-mid-gray font-medium xl:text-sm md:text-xs sm:text-sm text-xs tracking-[-0.096px] flex items-center sm:gap-2 gap-1.5">
                                        <span class="flex justify-center items-center w-5 h-5">
                                            <x-icon-location-outline-v2 />
                                        </span>
                                        {{ $job->address(1) }}
                                    </li>
                                @endif
                                @if ($job->postedDate())
                                    <li class="text-mid-gray font-medium xl:text-sm md:text-xs sm:text-sm text-xs tracking-[-0.096px] flex items-center sm:gap-2 gap-1.5 md:border-l border-solid border-gray-1200 md:px-2">
                                        <span class="flex justify-center items-center w-5 h-5">
                                            <x-icon-calendar-icon3 />
                                        </span>
                                        {{ __('Posted:') }} {{ $job->postedDate() }}
                                    </li>
                                @endif
                                @if ($job->deadlineDate())
                                    <li class="text-mid-gray font-medium xl:text-sm md:text-xs sm:text-sm text-xs tracking-[-0.096px] flex items-center sm:gap-2 gap-1.5 md:border-l border-solid border-gray-1200 md:px-2">
                                        <span class="flex justify-center items-center w-5 h-5">
                                            <x-icon-clock-icon />
                                        </span>
                                        {{ __('Deadline:') }} {{ $job->deadlineDate() }}
                                    </li>
                                @endif
                            </ul>
                        @endif
                    </div>
                </div>
                <div class="w-[321px] md:block hidden">

                    @if (!$hasAlreadyApplied)
                        <button type="button"
                            wire:click="applyJob"
                            wire:loading.attr="disabled"
                            class="w-full cursor-pointer primary-btn disabled:opacity-50">
                            <span wire:loading.remove>{{ __('Submit Application') }}</span>
                            <span wire:loading>{{ __('Submitting...') }}</span>
                        </button>
                    @endif
                </div>
            </div>

            @if ($hasAlreadyApplied)
                <div class="p-6 mt-8 text-center bg-green-50 rounded-lg border border-green-200">
                    <h3 class="mb-2 text-lg font-medium text-green-800">{{ __('Application Submitted') }}</h3>
                    <p class="text-green-700">{{ __('You have applied to this job. Thank you for your interest!') }}</p>
                </div>
            @else
                <form wire:submit.prevent="applyJob">
                    <div class="flex flex-col gap-6 mt-8 lg:flex-row">
                        <!-- Left Column -->
                        <div class="w-full lg:w-5/12">
                            @foreach ($leftColumnSections as $sectionKey => $section)
                                <div class="p-6 mb-8 rounded-2xl border border-solid border-gray-1200 shadow-7xl xl:p-6 lg:p-4">
                                    @if ($section['type'] === 'radio_group' && $sectionKey === 'availability')
                                        @include('livewire.frontend.job.partials.availability-section', ['section' => $section, 'sectionKey' => $sectionKey])
                                    @elseif($section['type'] === 'platform_selector' && $sectionKey === 'video_introduction')
                                        @include('livewire.frontend.job.partials.video-introduction-section', ['section' => $section, 'sectionKey' => $sectionKey])
                                    @elseif($section['type'] === 'radio' && in_array($sectionKey, ['legal_authorization', 'visa_sponsorship']))
                                        @include('livewire.frontend.job.partials.radio-section', ['section' => $section, 'sectionKey' => $sectionKey])
                                    @elseif($section['type'] === 'file' && $sectionKey === 'resume')
                                        @include('livewire.frontend.job.partials.file-upload-section', ['section' => $section, 'sectionKey' => $sectionKey])
                                    @endif
                                </div>
                            @endforeach
                        </div>

                        <!-- Right Column -->
                        <div class="w-full lg:w-7/12">
                            <div class="flex flex-col justify-between h-full">
                                @foreach ($rightColumnSections as $sectionKey => $section)
                                    @if ($section['type'] === 'rich_text')
                                        <div class="p-6 mb-8 rounded-2xl border border-solid border-gray-1200 shadow-7xl xl:p-6 lg:p-4">
                                            @include('livewire.frontend.job.partials.rich-text-section', ['section' => $section, 'sectionKey' => $sectionKey])
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <!-- User Registration Form (for non-authenticated users) -->
                    @guest
                        <div class="p-6 mt-8 rounded-2xl border border-solid border-gray-1200 shadow-7xl">
                            @include('livewire.frontend.job.partials.user-registration-section')
                        </div>
                    @endguest
                </form>
            @endif

            <!-- Mobile Submit Button -->
            @if (!$hasAlreadyApplied)
                <div class="w-full md:hidden block border-t border-solid border-gray-1200 px-[34px] py-6 mt-8">
                    <button type="button"
                        wire:click="applyJob"
                        wire:loading.attr="disabled"
                        class="w-full cursor-pointer primary-btn disabled:opacity-50">
                        <span wire:loading.remove>{{ __('Submit Application') }}</span>
                        <span wire:loading>{{ __('Submitting...') }}</span>
                    </button>
                </div>
            @endif

            <!-- Flash Messages -->
            @if (session()->has('success'))
                <div class="p-4 mt-4 bg-green-50 rounded-lg border border-green-200">
                    <p class="text-green-800">{{ session('success') }}</p>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="p-4 mt-4 bg-red-50 rounded-lg border border-red-200">
                    <p class="text-red-800">{{ session('error') }}</p>
                </div>
            @endif

            @if ($errors->any())
                <div class="p-4 mt-4 bg-red-50 rounded-lg border border-red-200">
                    <ul class="text-red-800">
                        @foreach ($errors->all() as $error)
                            <li>• {{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>
</div>
