<div class="max-w-[1310px] w-full mx-auto lg:px-4 px-0" x-data="initJobSearch()">
    <div>
        <div class="px-6 lg:px-0">
            <x-frontend.common.breadcrumb-v2 :name="$breadcrumbs['name']" :params="$breadcrumbs['params'] ?? null" />
            <div class="flex flex-col gap-10 justify-between items-start mt-3 lg:flex-row lg:items-center">
                <div class="flex-1 w-full lg:w-auto">
                    <h6>{{ $page->heading ?? __('Explore the latest jobs near you') }}</h6>
                    <p class="mt-1 text-xs font-medium leading-4 text-mid-gray">
                        {!! tiptap_converter()->asText($page->content) !!}
                    </p>
                    <ul class="flex flex-col gap-2 items-start mt-2 sm:flex-row sm:items-center">
                        <li class="text-xs font-medium leading-4 text-mid-gray">
                            {{ __('Showing :first to :last of :total results', [
                                'first' => $jobs->firstItem(),
                                'last' => $jobs->lastItem(),
                                'total' => $jobs->total(),
                            ]) }}
                            {{ $searchForTxt }}
                        </li>
                        {{-- <li class="flex gap-1.5 items-center text-xs font-medium leading-4 border-solid text-mid-gray sm:border-l border-gray-1200 sm:px-2">
                            <x-icon-refresh-icon-outline />
                            {{ __('Updated 5 minutes ago') }}
                        </li> --}}
                    </ul>
                </div>
                <div class="hidden gap-4 items-center lg:flex">
                    <x-frontend.includes.sort-dropdown-desktop :sort="$sort"
                        :sortText="$sortText"
                        component="frontend.job.partials.job-sort-dropdown" />
                </div>
            </div>
        </div>
    </div>
    <div class="lg:hidden block sticky top-0 z-[100] bg-white px-6 w-full pt-3.5 pb-2 border-b border-solid border-gray-1200">
        <ul class="grid grid-cols-2 gap-3">
            <li>
                <a href="javascript:void(0)"
                    @click="$refs.mobileSortModal.showModal()"
                    class="flex items-center  h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                    <x-icon-sort-icon />
                    {{ __('Sort') }}
                </a>
            </li>
            <li>
                <a href="javascript:void(0)"
                    @click="openFilter = !openFilter"
                    class="filter-btn flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                    <x-icon-list-bars />
                    {{ __('Filters') }}
                    @php
                        $filterCount = 0;
                        if (!empty($this->country)) {
                            $filterCount++;
                        }
                        if (!empty($this->state)) {
                            $filterCount++;
                        }
                        if (!empty($this->city)) {
                            $filterCount++;
                        }
                        if (!empty($this->work_mode)) {
                            $filterCount++;
                        }
                        if (!empty($this->job_type)) {
                            $filterCount++;
                        }
                        if (!empty($this->career_level)) {
                            $filterCount++;
                        }
                        if (!empty($this->job_industry)) {
                            $filterCount++;
                        }
                        if (!empty($this->job_type)) {
                            $filterCount++;
                        }
                        if (!empty($this->shift)) {
                            $filterCount++;
                        }
                        if (!empty($this->work_mode)) {
                            $filterCount++;
                        }
                        if (!empty($this->date_posted)) {
                            $filterCount++;
                        }
                    @endphp
                    ({{ $filterCount }})
                </a>
            </li>
        </ul>
    </div>
    <div class="flex flex-col-reverse gap-6 px-6 py-8 lg:flex-row xl:gap-8 lg:gap-4 lg:mt-8 lg:px-0 lg:py-0">
        <div class="lg:w-[318px] w-full">
            <div :class="{ 'active': openFilter }" class="bg-white lg:shadow-5xl lg:rounded-2xl lg:mb-8 filter-box transition-all duration-700 ease-in-out lg:static lg:h-auto fixed -left-full top-0 w-full h-full z-[100]">
                <div x-data="{
                    openLocation: @entangle('openLocation').defer,
                    openFilter: @entangle('openFilter').defer,
                    openCategory: @entangle('openCategory').defer,
                    openJobType: @entangle('openJobType').defer,
                    openJobRole: @entangle('openJobRole').defer,
                    openWorkingHours: @entangle('openWorkingHours').defer,
                    openExperience: @entangle('openExperience').defer,
                    openRemoteWork: @entangle('openRemoteWork').defer,
                    openSalary: @entangle('openSalary').defer,
                    openDatePosted: @entangle('openDatePosted').defer,
                    openDeadline: @entangle('openDeadline').defer,
                    openJobRole: @entangle('openJobRole').defer,
                }"
                    id="search-sidebar-{{ $this->getId() }}"
                    data-component-id="{{ $this->getId() }}"
                    data-country="{{ $countryCode ?: '' }}">
                    @include('components.frontend.job.sidebar.search-sidebar')
                </div>
            </div>
            <div class="hidden lg:block">
                <x-frontend.sidebar.widgets.ads-alert type="Job" />
            </div>
        </div>
        <div class="relative lg:w-[calc(100%_-_350px)] w-full">
            <div x-show="jobListLoading" class="absolute inset-0 z-50 w-full h-full bg-white backdrop-blur-sm">
                <x-frontend.includes.loading-overlay-list :rows="6"
                    layout="job-list"
                    class="mt-4" />
            </div>
            <div>
                @if ($jobs->isNotEmpty())
                    @foreach ($jobs as $job)
                        <x-frontend.job.job-card :job="$job" />
                        @if ($loop->iteration % 4 == 0)
                            <div class="mb-6">
                                <x-frontend.sidebar.widgets.member-free-promotion-card />
                            </div>
                        @endif
                    @endforeach
                    @if ($jobs->hasPages())
                        <div class="mt-9">
                            {{ $jobs->links('vendor.livewire.esp-sleek-pagination') }}
                        </div>
                    @endif
                @else
                    <x-common.no-records-found>
                        <x-slot:icon>
                            <x-icon-search-icon />
                        </x-slot:icon>
                        <x-slot:title>
                            {{ __('No Jobs found') }}
                        </x-slot:title>
                        <x-slot:description>
                            {{ __('No Jobs for this search found') }}
                        </x-slot:description>
                    </x-common.no-records-found>
                @endif

            </div>

            <div class="block mt-9 md:hidden">
                <x-frontend.sidebar.widgets.ads-alert type="Job" />
            </div>
        </div>
        <!-- Mobile Sort Modal -->
        <x-frontend.includes.sort-modal-mobile :sort="$sort"
            :sortText="$sortText"
            component="frontend.job.partials.job-sort-dropdown" />
    </div>
</div>
