<div x-data class="relative h-full bg-white md:rounded-xl md:h-auto">
    <a href="javascript:void(0)"
        onclick="Livewire.dispatch('closeModal')"
        class="flex absolute top-6 right-6 justify-center items-center w-6 h-6 md:right-4 md:top-4">
        <x-icon-close-icon />
    </a>
    <!-- Modal body -->
    <div class="p-3">
        <div class="px-5 py-10 rounded-2xl bg-gray-1400">
            <span class="flex items-center justify-center mx-auto bg-blue-1400/[0.10] w-14 h-14 rounded-full">
                <svg class="h-3.5"
                    viewBox="0 0 13 10"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M5.00005 7.379L11.8941 0.484253L12.9553 1.54475L5.00005 9.5L0.227051 4.727L1.28755 3.6665L5.00005 7.379Z" fill="#335CFF" />
                </svg>
            </span>
            <h4 class="my-6 text-xl font-medium leading-8 text-center text-black-1200 sm:text-2xl">
                {{ __('Your application was sent! Good luck!') }}
            </h4>
            <p class="mb-6 text-xs font-medium leading-4 text-center text-mid-gray">
                {{ __('Most employers review applications within a few days. They’ll get back to you once your application is reviewed.') }}
            </p>
            <a href="{{ route('job.index') }}" class="text-white font-medium text-sm leading-5 tracking-[-0.096px] bg-primary-blue flex items-center justify-center rounded-full h-10 max-w-[151px] w-full mx-auto">
                {{ __('Browse More Jobs') }}
            </a>
        </div>
        @if ($relatedJobs->isNotEmpty())
            <div class="px-3 pt-10 pb-7">
                <h4 class="text-lg font-semibold leading-6 text-center text-black-1200">
                    {{ __('You’re a good match for these similar jobs') }}
                </h4>
                <div class="mt-8 max-w-[800px] w-full mx-auto">
                    @foreach ($relatedJobs as $job)
                        <x-frontend.job.job-card :job="$job" />
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>
